/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;

@Service
public class ObjectPropertyOpService {
    private ObjectPropertyService objectPropertyService = ObjectPropertyService.getInstance();
    private ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();

    public List<String> getPropertyValues(ObjectPropertiesKey key) {
        return this.objectPropertyService.getPropertyValues(key);
    }

    public void setPropertyValue(ObjectPropertiesKey key, String value, String desc) {
        this.objectPropertyService.setPropertyValue(key, value, desc);
    }

    public void setPropertyValues(ObjectPropertiesKey key, List<String> values, String desc) {
        this.objectPropertyService.setPropertyValues(key, values, desc);
    }

    public String getCustomNoteField(String bankVersionID) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("detail_note_select", "BANK_BUSINESS", bankVersionID);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }

    public String getBankSearchDetailDate(String bankVersionID) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("detail_search_date", "BANK_BUSINESS", bankVersionID);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }

    public String getAccnoSearchLimit(String accNo) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("accno_search_limit", "BANK_BUSINESS", accNo);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }

    public String isOpenPayForSalary(String bankVersionID) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("IS_OPEN_PAY_FOR_SALARY", "BANK_BUSINESS", bankVersionID);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }

    public boolean isUseKDFlag(String bankVersionID) {
        boolean result = true;
        String entity = "aqap_object_properties";
        QFilter filter = QFilter.of((String)"object_id=?", (Object[])new Object[]{bankVersionID});
        filter.and(QFilter.like((String)"attr_key", (String)"isAddKDFlagToPay"));
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entity, (String)"attr_key, attr_value, object_id, object_name", (QFilter[])filter.toArray());
        if (object != null) {
            String value = object.getString("attr_value");
            result = "addKDFlag".equals(value) || "true".equals(value);
        }
        return result;
    }
}

