/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.aqap.common.model.transform.BatchUpdateCollector;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class CurAndFixedRepository {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedRepository.class);
    private static final String DUPLICATE_ENTRY_INFO = "Duplicate entry";
    private static final String DUPLICATE_KEY_DETAIL_BIZ_NO = "FDETAIL_BIZ_NO";
    private String CAF_ENTITY = "bank_cafinfo";
    public static final String SELECT_ALL_PROPERTIES = "ID,number,name,status,creatorid,modifierid,enable,createtime,modifytime,masterid,biz_type,impl_class,detail_seq,fixed_acc,inftyp,cur_acc,amount,explanation,draw_type,cur_name,bank_name,bank_no,fixed_name,fixed_bank_name,fixed_bank_no,deposit_term,next_deposit,next_term,currency,bank_version,customid,batch_seq_id,detail_seq_id,detail_biz_no,reqnbr,back_bank_status,bank_login,version,accbal,trantime,trandate,opendate,closedate,ratedate,endintdate,enddate,expireop,rate,fixint,fixtaxint,fixactint,closeint,status_msg,status_name,bank_status,bank_status_msg,insert_time,update_time,submit_success_time,error_msg,bank_msg,back_error_msg,notify_id,price_no,reserve1,reserve2";

    public void save(CurAndFixedInfo info) {
        if (info != null) {
            DynamicObject dynamicObject = this.packCafInfo(null, info);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public List<CurAndFixedInfo> save(List<CurAndFixedInfo> infos) {
        ArrayList<CurAndFixedInfo> insertList = new ArrayList<CurAndFixedInfo>(1);
        ArrayList<CurAndFixedInfo> updateList = new ArrayList<CurAndFixedInfo>(1);
        for (CurAndFixedInfo info : infos) {
            String id = info.getId();
            if (StringUtils.isNotEmpty((String)id) && QueryServiceHelper.exists((String)this.CAF_ENTITY, (Object)Long.parseLong(id))) {
                updateList.add(info);
                continue;
            }
            insertList.add(info);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
        return infos;
    }

    private void updateAll(List<CurAndFixedInfo> curAndFixedInfos) {
        if (!curAndFixedInfos.isEmpty()) {
            try {
                logger.info("\u5f85\u66f4\u65b0\u7406\u8d22\u8bb0\u5f55\uff1a{}\u6761", (Object)curAndFixedInfos.size());
                for (CurAndFixedInfo curAndFixedInfo : curAndFixedInfos) {
                    ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.CAF_ENTITY);
                    dynamicObjectList.add(this.packCafInfo(dynamicObject, curAndFixedInfo));
                    ArrayList<CurAndFixedInfo> curAndFixedInfoList = new ArrayList<CurAndFixedInfo>(1);
                    curAndFixedInfoList.add(curAndFixedInfo);
                    DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
                    this.updateWithVersion(dynamicObjects, curAndFixedInfoList);
                }
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25");
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u66f4\u65b0\u8bb0\u5f55\u65f6\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"CurAndFixedRepository_0", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u8bb0\u5f55\u5165\u5e93\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CurAndFixedRepository_1", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void insertAll(List<CurAndFixedInfo> curAndFixedInfos) {
        if (!curAndFixedInfos.isEmpty()) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            for (CurAndFixedInfo curAndFixedInfo : curAndFixedInfos) {
                dynamicObjectList.add(this.packCafInfo(null, curAndFixedInfo));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[curAndFixedInfos.size()]);
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)objs[i];
                    curAndFixedInfos.get(i).setId(dynamicObject.getString("id"));
                }
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u6307\u4ee4\u4e2d\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"CurAndFixedRepository_2", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u8bb0\u5f55\u5165\u5e93\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CurAndFixedRepository_3", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public void update(CurAndFixedInfo info) {
        String id;
        DynamicObject dynamicObject;
        if (info != null && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id = info.getId()), (String)this.CAF_ENTITY)) != null) {
            DynamicObject dynamicObject1 = this.packCafInfo(dynamicObject, info);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject1});
        }
    }

    public List<CurAndFixedInfo> selectInfoByID(String id) {
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter qFilter = QFilter.of((String)"id = ?", (Object[])new Object[]{id});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : collection) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public long countByBatchSeqID(String batchSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.CAF_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");
        long total = ds.count("id", Boolean.FALSE.booleanValue());
        return total;
    }

    public List<CurAndFixedInfo> findByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and detail_seq_id = ?", (Object[])new Object[]{batchSeqID, detailSeqID});
        DynamicObject[] var6 = dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        int var7 = dynamicObjects.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            DynamicObject dynamicObject = var6[var8];
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    private DynamicObject packCafInfo(DynamicObject dynamicObject, CurAndFixedInfo curAndFixedInfo) {
        Date time;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.CAF_ENTITY);
        } else {
            this.setDynamicParamater(dynamicObject, "id", Long.parseLong(curAndFixedInfo.getId()));
        }
        dynamicObject.set("biz_type", (Object)curAndFixedInfo.getSubBizType());
        dynamicObject.set("impl_class", (Object)curAndFixedInfo.getImplClassName());
        dynamicObject.set("status", (Object)curAndFixedInfo.getStatus());
        dynamicObject.set("detail_seq", (Object)curAndFixedInfo.getDetailSeqId());
        dynamicObject.set("fixed_acc", (Object)curAndFixedInfo.getFixedAccNo());
        dynamicObject.set("inftyp", (Object)curAndFixedInfo.getInftyp());
        dynamicObject.set("cur_acc", (Object)curAndFixedInfo.getAccNo());
        this.setDynamicParamater(dynamicObject, "amount", curAndFixedInfo.getAmount());
        dynamicObject.set("explanation", (Object)curAndFixedInfo.getExplanation());
        dynamicObject.set("draw_type", (Object)curAndFixedInfo.getDrawType());
        dynamicObject.set("cur_name", (Object)curAndFixedInfo.getAccName());
        dynamicObject.set("bank_name", (Object)curAndFixedInfo.getAcntBank());
        dynamicObject.set("bank_no", (Object)curAndFixedInfo.getAcntBankNo());
        dynamicObject.set("fixed_name", (Object)curAndFixedInfo.getFixedAccName());
        dynamicObject.set("fixed_bank_name", (Object)curAndFixedInfo.getFixedAcntBank());
        dynamicObject.set("fixed_bank_no", (Object)curAndFixedInfo.getFixedAcntBankNo());
        dynamicObject.set("deposit_term", (Object)curAndFixedInfo.getDepositTermValue());
        dynamicObject.set("next_deposit", (Object)curAndFixedInfo.getNextDepositType());
        dynamicObject.set("next_term", (Object)curAndFixedInfo.getNextDepositTermValue());
        dynamicObject.set("currency", (Object)curAndFixedInfo.getCurrency());
        this.setDynamicParamater(dynamicObject, "bank_version", curAndFixedInfo.getBankVersion());
        this.setDynamicParamater(dynamicObject, "customid", curAndFixedInfo.getCustomId());
        this.setDynamicParamater(dynamicObject, "batch_seq_id", curAndFixedInfo.getBatchSeqId());
        this.setDynamicParamater(dynamicObject, "detail_seq_id", curAndFixedInfo.getDetailSeqId());
        this.setDynamicParamater(dynamicObject, "detail_biz_no", curAndFixedInfo.getDetailBizNo());
        this.setDynamicParamater(dynamicObject, "reqnbr", curAndFixedInfo.getReqNbr());
        if (StringUtils.isEmpty((String)curAndFixedInfo.getBackBankStatus())) {
            curAndFixedInfo.setDetailBizNo(curAndFixedInfo.getDetailSeqId());
        }
        if (curAndFixedInfo.getStatus().intValue() == CurAndFixedState.FAIL.getId()) {
            curAndFixedInfo.setBackBankStatus(curAndFixedInfo.getDetailSeqId());
        } else {
            curAndFixedInfo.setBackBankStatus("1");
        }
        this.setDynamicParamater(dynamicObject, "back_bank_status", curAndFixedInfo.getBackBankStatus());
        this.setDynamicParamater(dynamicObject, "bank_login", curAndFixedInfo.getBankLoginId());
        if (curAndFixedInfo.getVersion() == null) {
            curAndFixedInfo.setVersion(1);
        }
        this.setDynamicParamater(dynamicObject, "version", curAndFixedInfo.getVersion());
        this.setDynamicParamater(dynamicObject, "accbal", curAndFixedInfo.getAccBal());
        if (curAndFixedInfo.getTranDate() != null) {
            time = Date.from(curAndFixedInfo.getTranDate().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("trandate", (Object)time);
        }
        if (curAndFixedInfo.getTranDate() != null) {
            time = Date.from(curAndFixedInfo.getTranDate().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("trantime", (Object)time);
        }
        this.setDynamicParamater(dynamicObject, "opendate", curAndFixedInfo.getOpenDate());
        this.setDynamicParamater(dynamicObject, "closedate", curAndFixedInfo.getCloseDate());
        this.setDynamicParamater(dynamicObject, "ratedate", curAndFixedInfo.getRateDate());
        this.setDynamicParamater(dynamicObject, "endintdate", curAndFixedInfo.getEndIntDate());
        this.setDynamicParamater(dynamicObject, "enddate", curAndFixedInfo.getEndDate());
        this.setDynamicParamater(dynamicObject, "expireop", curAndFixedInfo.getExpireOp());
        this.setDynamicParamater(dynamicObject, "rate", curAndFixedInfo.getRate());
        this.setDynamicParamater(dynamicObject, "fixint", curAndFixedInfo.getFixInt());
        this.setDynamicParamater(dynamicObject, "fixtaxint", curAndFixedInfo.getFixTaxInt());
        this.setDynamicParamater(dynamicObject, "fixactint", curAndFixedInfo.getFixActInt());
        this.setDynamicParamater(dynamicObject, "status_msg", curAndFixedInfo.getStatusMsg());
        this.setDynamicParamater(dynamicObject, "status_name", curAndFixedInfo.getStatusName());
        this.setDynamicParamater(dynamicObject, "bank_status", curAndFixedInfo.getBankStatus());
        this.setDynamicParamater(dynamicObject, "bank_status_msg", curAndFixedInfo.getBankStatusMsg());
        this.setDynamicParamater(dynamicObject, "error_msg", curAndFixedInfo.getErrorMsg());
        this.setDynamicParamater(dynamicObject, "bank_msg", curAndFixedInfo.getBankMsg());
        this.setDynamicParamater(dynamicObject, "back_error_msg", curAndFixedInfo.getBackErrorMsg());
        if (curAndFixedInfo.getInsertTime() != null) {
            time = Date.from(curAndFixedInfo.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("insert_time", (Object)time);
        }
        if (curAndFixedInfo.getUpdateTime() != null) {
            time = Date.from(curAndFixedInfo.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)time);
        }
        if (curAndFixedInfo.getSubmitSuccessTime() != null) {
            time = Date.from(curAndFixedInfo.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submit_success_time", (Object)time);
        }
        this.setDynamicParamater(dynamicObject, "notify_id", curAndFixedInfo.getNotifyId());
        this.setDynamicParamater(dynamicObject, "price_no", curAndFixedInfo.getPriceNo());
        this.setDynamicParamater(dynamicObject, "number", curAndFixedInfo.getSyncCount());
        this.setDynamicParamater(dynamicObject, "reserve1", curAndFixedInfo.getReserved1());
        this.setDynamicParamater(dynamicObject, "reserve2", curAndFixedInfo.getReserved2());
        return dynamicObject;
    }

    private CurAndFixedInfo transCafInfo(DynamicObject dynamicObject) {
        CurAndFixedInfo curAndFixedInfo = new CurAndFixedInfo();
        String time = "";
        curAndFixedInfo.setId(dynamicObject.getString("id"));
        curAndFixedInfo.setStatus(dynamicObject.getInt("status"));
        curAndFixedInfo.setSubBizType(dynamicObject.getString("biz_type"));
        curAndFixedInfo.setImplClassName(dynamicObject.getString("impl_class"));
        curAndFixedInfo.setInftyp(dynamicObject.getString("inftyp"));
        curAndFixedInfo.setDetailSeqId(dynamicObject.getString("detail_seq"));
        curAndFixedInfo.setFixedAccNo(dynamicObject.getString("fixed_acc"));
        curAndFixedInfo.setAccNo(dynamicObject.getString("cur_acc"));
        curAndFixedInfo.setAmount(dynamicObject.getString("amount"));
        curAndFixedInfo.setExplanation(dynamicObject.getString("explanation"));
        curAndFixedInfo.setDrawType(dynamicObject.getString("draw_type"));
        curAndFixedInfo.setAccName(dynamicObject.getString("cur_name"));
        curAndFixedInfo.setAcntBank(dynamicObject.getString("bank_name"));
        curAndFixedInfo.setAcntBankNo(dynamicObject.getString("bank_no"));
        curAndFixedInfo.setFixedAccName(dynamicObject.getString("fixed_name"));
        curAndFixedInfo.setFixedAcntBank(dynamicObject.getString("fixed_bank_name"));
        curAndFixedInfo.setFixedAcntBankNo(dynamicObject.getString("fixed_bank_no"));
        curAndFixedInfo.setDepositTermValue(dynamicObject.getString("deposit_term"));
        curAndFixedInfo.setNextDepositType(dynamicObject.getString("next_deposit"));
        curAndFixedInfo.setNextDepositTermValue(dynamicObject.getString("next_term"));
        curAndFixedInfo.setCurrency(dynamicObject.getString("currency"));
        curAndFixedInfo.setBankVersion(dynamicObject.getString("bank_version"));
        curAndFixedInfo.setVersion(dynamicObject.getInt("version"));
        curAndFixedInfo.setCustomId(dynamicObject.getString("customid"));
        curAndFixedInfo.setBatchSeqId(dynamicObject.getString("batch_seq_id"));
        curAndFixedInfo.setDetailSeqId(dynamicObject.getString("detail_seq_id"));
        curAndFixedInfo.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        curAndFixedInfo.setReqNbr(dynamicObject.getString("reqnbr"));
        curAndFixedInfo.setBackBankStatus(dynamicObject.getString("back_bank_status"));
        curAndFixedInfo.setBankLoginId(dynamicObject.getString("bank_login"));
        time = dynamicObject.getString("trandate");
        if (!this.isEmpty(time)) {
            curAndFixedInfo.setTranDate(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("trantime"))) {
            curAndFixedInfo.setTranTime(DTFactoryUtil.parseDateTime((String)time));
        }
        curAndFixedInfo.setOpenDate(dynamicObject.getString("opendate"));
        curAndFixedInfo.setCloseDate(dynamicObject.getString("closedate"));
        curAndFixedInfo.setRateDate(dynamicObject.getString("ratedate"));
        curAndFixedInfo.setEndIntDate(dynamicObject.getString("endintdate"));
        curAndFixedInfo.setEndDate(dynamicObject.getString("enddate"));
        curAndFixedInfo.setExpireOp(dynamicObject.getString("expireop"));
        curAndFixedInfo.setRate(dynamicObject.getString("rate"));
        curAndFixedInfo.setFixInt(dynamicObject.getString("fixint"));
        curAndFixedInfo.setFixTaxInt(dynamicObject.getString("fixtaxint"));
        curAndFixedInfo.setFixActInt(dynamicObject.getString("fixactint"));
        curAndFixedInfo.setCloseInt(dynamicObject.getString("closeint"));
        curAndFixedInfo.setStatusMsg(dynamicObject.getString("status_msg"));
        curAndFixedInfo.setStatusName(dynamicObject.getString("status_name"));
        curAndFixedInfo.setBankStatus(dynamicObject.getString("bank_status"));
        curAndFixedInfo.setBankStatusMsg(dynamicObject.getString("bank_status_msg"));
        curAndFixedInfo.setErrorMsg(dynamicObject.getString("error_msg"));
        curAndFixedInfo.setBankMsg(dynamicObject.getString("bank_msg"));
        curAndFixedInfo.setBackErrorMsg(dynamicObject.getString("back_error_msg"));
        time = dynamicObject.getString("insert_time");
        if (!this.isEmpty(time)) {
            curAndFixedInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
            curAndFixedInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("submit_success_time"))) {
            curAndFixedInfo.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        curAndFixedInfo.setNotifyId(dynamicObject.getString("notify_id"));
        curAndFixedInfo.setPriceNo(dynamicObject.getString("price_no"));
        curAndFixedInfo.setSyncCount(dynamicObject.getString("number"));
        curAndFixedInfo.setReserved1(dynamicObject.getString("reserve1"));
        curAndFixedInfo.setReserved2(dynamicObject.getString("reserve2"));
        return curAndFixedInfo;
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    private String getDuplicateKeyDetailBizNo(String errorMsg, String tips) {
        String result = tips;
        int startIndex = errorMsg.indexOf(DUPLICATE_ENTRY_INFO) + DUPLICATE_ENTRY_INFO.length();
        int endIndex = errorMsg.indexOf(DUPLICATE_KEY_DETAIL_BIZ_NO);
        if (startIndex > 0 && endIndex > 0 && endIndex > startIndex) {
            String msg = errorMsg.substring(startIndex, endIndex);
            String[] items = msg.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String item : items) {
                int index = item.lastIndexOf(45);
                if (index <= 0) continue;
                item = item.substring(0, index);
                sb.append(tips).append('[').append(item.replaceAll("'", "")).append(']');
                break;
            }
            result = sb.toString();
        }
        return result;
    }

    public void updateWithVersion(DynamicObject[] dynamicObjects, List<CurAndFixedInfo> curAndFixedInfos) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet((Object[])dynamicObjects, true);
        BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateCollector(saveDataSet);
        TXHandle h = TX.required();
        try {
            int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), batchUpdateCollector.getListParas());
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != 0) continue;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u4e50\u89c2\u9501\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            for (CurAndFixedInfo info : curAndFixedInfos) {
                info.setVersion(info.getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable result) {}
            }
        }
    }

    public BatchUpdateCollector getBatchUpdateCollector(SaveDataSet saveDataSet) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>(1);
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>(1);
            StringBuilder sql = new StringBuilder();
            long version = 0L;
            long id = 0L;
            sql.append("UPDATE ").append(dataTable.getSchema().getName()).append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (columName.equalsIgnoreCase("fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (columName.equalsIgnoreCase("fversion")) {
                    version = (Long)field.getValue();
                    continue;
                }
                if (field.getValue() == null) continue;
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            sql.append("WHERE fversion=? and Fid=?");
            paras.add(version);
            paras.add(id);
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public List<CurAndFixedInfo> selectByBatchSeqID(String batchSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> selectByNotifyIdAndFixedAcc(String id, String no) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"notify_id = ? and fixed_acc = ?", (Object[])new Object[]{id, no});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> selectByStatusANdTime(LocalDateTime time, int id) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"insert_time > ? and status = ?", (Object[])new Object[]{time, String.valueOf(id)});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> selectByReqNbr(String no) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"reqnbr = ?", (Object[])new Object[]{no});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> selectByFixedAccNoAndCurAccNo(String fixed, String cur) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"fixed_acc = ? and cur_acc = ?", (Object[])new Object[]{fixed, cur});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> selectByStatusBetweenUpdateTimeLowerSyncCount(int start, int end, LocalDateTime time, int limit) {
        DynamicObject[] dynamicObjects;
        ArrayList<CurAndFixedInfo> curAndFixedInfos = new ArrayList<CurAndFixedInfo>(1);
        QFilter filter = QFilter.of((String)"status >= ? and status <= ? and update_time < ?", (Object[])new Object[]{String.valueOf(start), String.valueOf(end), time});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.CAF_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            curAndFixedInfos.add(this.transCafInfo(dynamicObject));
        }
        return curAndFixedInfos;
    }
}

