/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.InstanceReg;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class InstanceRegRepository {
    private String entity = "aqap_instance_reg";
    private String properties = "id,cluster_name,app_name,config_app_name,instance_name,ip_address,web_port,monitor_port,start_time,valid,node_path,host_name,type";

    public void save(List<InstanceReg> instanceRegList) {
        ArrayList<InstanceReg> insertList = new ArrayList<InstanceReg>(1);
        ArrayList<InstanceReg> updateList = new ArrayList<InstanceReg>(1);
        for (InstanceReg instanceReg : instanceRegList) {
            if (StringUtils.isNotEmpty((String)instanceReg.getId())) {
                updateList.add(instanceReg);
                continue;
            }
            insertList.add(instanceReg);
        }
        this.update(updateList);
        this.insert(insertList);
    }

    public List<InstanceReg> findAll() {
        ArrayList<InstanceReg> instanceRegs = new ArrayList<InstanceReg>(1);
        QFilter filter = QFilter.of((String)"type=?", (Object[])new Object[]{"ebg"});
        ArrayList<String> nodeInfoFilter = new ArrayList<String>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        ArrayList<Long> pkIDs = new ArrayList<Long>(16);
        if (dynamicObjects != null) {
            IDataEntityType dataEntityType = null;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dataEntityType = dynamicObject.getDataEntityType();
                InstanceReg instanceReg = new InstanceReg();
                instanceReg.setId(dynamicObject.getString("id"));
                instanceReg.setAppName(dynamicObject.getString("app_name"));
                instanceReg.setClusterName(dynamicObject.getString("cluster_name"));
                instanceReg.setConfigAppName(dynamicObject.getString("config_app_name"));
                instanceReg.setHostName(dynamicObject.getString("host_name"));
                instanceReg.setInstanceId(dynamicObject.getString("instance_name"));
                instanceReg.setIp(dynamicObject.getString("ip_address"));
                instanceReg.setWebPort(dynamicObject.getInt("web_port"));
                instanceReg.setMonitorPort(dynamicObject.getInt("monitor_port"));
                instanceReg.setNodePath(dynamicObject.getString("node_path"));
                instanceReg.setValid(dynamicObject.getBoolean("valid"));
                instanceReg.setType(dynamicObject.getString("type"));
                String time = dynamicObject.getString("start_time");
                instanceReg.setStartTime(DTFactoryUtil.parseDateTime((String)time));
                if (!nodeInfoFilter.contains(instanceReg.getNodeInfo())) {
                    nodeInfoFilter.add(instanceReg.getNodeInfo());
                    instanceRegs.add(instanceReg);
                    continue;
                }
                pkIDs.add(Long.valueOf(instanceReg.getId()));
            }
            if (dataEntityType != null && pkIDs.size() > 0) {
                try {
                    DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])pkIDs.toArray());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return instanceRegs;
    }

    private void update(List<InstanceReg> instanceRegList) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (InstanceReg instanceReg : instanceRegList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
            dynamicObject.set("id", (Object)Long.parseLong(instanceReg.getId()));
            dynamicObject.set("cluster_name", (Object)instanceReg.getClusterName());
            dynamicObject.set("app_name", (Object)instanceReg.getAppName());
            dynamicObject.set("config_app_name", (Object)instanceReg.getConfigAppName());
            dynamicObject.set("instance_name", (Object)instanceReg.getInstanceId());
            dynamicObject.set("ip_address", (Object)instanceReg.getIp());
            dynamicObject.set("web_port", (Object)instanceReg.getWebPort());
            dynamicObject.set("monitor_port", (Object)instanceReg.getMonitorPort());
            if (instanceReg.getStartTime() != null) {
                Date time = Date.from(instanceReg.getStartTime().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("start_time", (Object)time);
            }
            dynamicObject.set("valid", (Object)String.valueOf(instanceReg.isValid()));
            dynamicObject.set("node_path", (Object)instanceReg.getNodePath());
            dynamicObject.set("host_name", (Object)instanceReg.getHostName());
            dynamicObject.set("type", (Object)instanceReg.getType());
            dynamicObject.set("status", (Object)"A");
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    private void insert(List<InstanceReg> instanceRegList) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (InstanceReg instanceReg : instanceRegList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
            dynamicObject.set("cluster_name", (Object)instanceReg.getClusterName());
            dynamicObject.set("app_name", (Object)instanceReg.getAppName());
            dynamicObject.set("config_app_name", (Object)instanceReg.getConfigAppName());
            dynamicObject.set("instance_name", (Object)instanceReg.getInstanceId());
            dynamicObject.set("ip_address", (Object)instanceReg.getIp());
            dynamicObject.set("web_port", (Object)instanceReg.getWebPort());
            dynamicObject.set("monitor_port", (Object)instanceReg.getMonitorPort());
            if (instanceReg.getStartTime() != null) {
                Date time = Date.from(instanceReg.getStartTime().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("start_time", (Object)time);
            }
            dynamicObject.set("valid", (Object)String.valueOf(instanceReg.isValid()));
            dynamicObject.set("node_path", (Object)instanceReg.getNodePath());
            dynamicObject.set("host_name", (Object)instanceReg.getHostName());
            dynamicObject.set("type", (Object)instanceReg.getType());
            dynamicObject.set("status", (Object)"A");
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void clearHistory() {
        long historyDays = 7L;
        LocalDateTime time = LocalDateTime.now().minusDays(historyDays);
        QFilter filter = QFilter.of((String)"createtime<?", (Object[])new Object[]{time});
        DeleteServiceHelper.delete((String)this.entity, (QFilter[])filter.toArray());
    }
}

