/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository.receipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.receipt.ReceiptJson;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class EBCReceiptInfoJsonRepository {
    private String DETAILINFO_ENTITY = "ebc_receipt_json";
    private String SELECT_ALL_PROPERTIES = "id,custom_id,receipt_detail_id,json,modifytime,createtime";

    public ReceiptJson save(ReceiptJson info) {
        DynamicObject dynamicObject = this.packDetailInfo(null, info);
        DynamicObject[] resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        ReceiptJson receiptJson = this.toEBCReceiptJson(resultArray[0]);
        return receiptJson;
    }

    public void update(ReceiptJson info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void delete(ReceiptJson info) {
        long id = info.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public void batchDeleteByDetailIds(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            int pageSize = 1000;
            if (ids.size() <= pageSize) {
                QFilter filter = new QFilter("receipt_detail_id", "in", ids);
                DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])filter.toArray());
                return;
            }
            int count = ids.size();
            int page = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
            for (int i = 0; i < page; ++i) {
                int startIndex = i * pageSize;
                int endIndex = (i + 1) * pageSize;
                int initCapacity = pageSize;
                if (i == page - 1) {
                    endIndex = count;
                    initCapacity = count - startIndex;
                }
                List<Object> deleteIds = new ArrayList(initCapacity);
                deleteIds = ids.subList(startIndex, endIndex);
                QFilter filter = new QFilter("receipt_detail_id", "in", deleteIds);
                DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])filter.toArray());
            }
        }
    }

    public ReceiptJson findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            ReceiptJson receiptInfo = this.toEBCReceiptJson(dynamicObject);
            return receiptInfo;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public ReceiptJson findByReceiptDetailId(String receiptDetailId) {
        String expressionStr;
        QFilter filter;
        DynamicObject dynamicObject;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(1);
        if (!StringUtils.isEmpty((String)receiptDetailId)) {
            expression.append("receipt_detail_id=?");
            paramsList.add(receiptDetailId);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)(expressionStr = expression.toString()), (Object[])paramsList.toArray())).toArray())) == null) {
            return null;
        }
        ReceiptJson receiptInfo = this.toEBCReceiptJson(dynamicObject);
        return receiptInfo;
    }

    private ReceiptJson toEBCReceiptJson(DynamicObject dynamicObject) {
        ReceiptJson info = new ReceiptJson();
        info.setId(dynamicObject.getLong("id"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        info.setCustomNo(dynamicObject.getString("custom_id"));
        info.setReceiptDetailId(dynamicObject.getString("receipt_detail_id"));
        info.setJson(dynamicObject.getString("json"));
        return info;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, ReceiptJson info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("receipt_detail_id", (Object)info.getReceiptDetailId());
        dynamicObject.set("json", (Object)info.getJson());
        return dynamicObject;
    }
}

