/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository.receipt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.receipt.TradeDetailJson;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class TradeDetailJsonRepository {
    private static final String DETAILINFO_ENTITY = "aqap_detail_json";
    private static final String SELECT_ALL_PROPERTIES = "id,custom_id,aqap_detail_id,json,json_tag,bank_version.number,modifytime,createtime";

    public TradeDetailJson save(TradeDetailJson info) {
        DynamicObject dynamicObject = this.packCurrentInfo(null, info);
        DynamicObject[] resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        TradeDetailJson receiptJson = this.toCurrentInfo(resultArray[0]);
        return receiptJson;
    }

    public List<TradeDetailJson> saveAll(List<TradeDetailJson> infos) {
        DynamicObject[] resultArray;
        if (CollectionUtil.isEmpty(infos)) {
            return Lists.newArrayList();
        }
        ArrayList<TradeDetailJson> tradeDetailJsonList = new ArrayList<TradeDetailJson>(infos.size());
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(infos.size());
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(infos.get(0).getBankVersionId());
        for (TradeDetailJson info : infos) {
            DynamicObject dynamicObject = this.packCurrentInfo(null, info, bankVersion);
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
        for (DynamicObject dy : resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dynamicObjects)) {
            TradeDetailJson receiptJson = this.toCurrentInfo(dy);
            tradeDetailJsonList.add(receiptJson);
        }
        return tradeDetailJsonList;
    }

    public void update(TradeDetailJson info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packCurrentInfo(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void delete(TradeDetailJson info) {
        long id = info.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public void batchDeleteByDetailIds(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            int pageSize = 1000;
            if (ids.size() <= pageSize) {
                QFilter filter = new QFilter("receipt_detail_id", "in", ids);
                DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
                return;
            }
            int count = ids.size();
            int page = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
            for (int i = 0; i < page; ++i) {
                int startIndex = i * pageSize;
                int endIndex = (i + 1) * pageSize;
                int initCapacity = pageSize;
                if (i == page - 1) {
                    endIndex = count;
                    initCapacity = count - startIndex;
                }
                List<Object> deleteIds = new ArrayList(initCapacity);
                deleteIds = ids.subList(startIndex, endIndex);
                QFilter filter = new QFilter("receipt_detail_id", "in", deleteIds);
                DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
            }
        }
    }

    public TradeDetailJson findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            TradeDetailJson receiptInfo = this.toCurrentInfo(dynamicObject);
            return receiptInfo;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public TradeDetailJson findByDetailId(String detailId) {
        String expressionStr;
        QFilter filter;
        DynamicObject dynamicObject;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(1);
        if (!StringUtils.isEmpty((String)detailId)) {
            expression.append("aqap_detail_id=?");
            paramsList.add(detailId);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)(expressionStr = expression.toString()), (Object[])paramsList.toArray())).toArray())) == null) {
            return null;
        }
        TradeDetailJson receiptInfo = this.toCurrentInfo(dynamicObject);
        return receiptInfo;
    }

    public List<TradeDetailJson> findListByCustomIdAndBankVersionId(String customId, String bankVersionId) {
        StringBuilder expression = new StringBuilder();
        ArrayList<TradeDetailJson> tradeDetailJsonList = new ArrayList<TradeDetailJson>(1);
        ArrayList<String> paramsList = new ArrayList<String>(1);
        expression.append("1=1");
        if (!StringUtils.isEmpty((String)customId)) {
            expression.append("and custom_id=?");
            paramsList.add(customId);
        }
        if (!StringUtils.isEmpty((String)bankVersionId)) {
            expression.append("and bank_version.number=?");
            paramsList.add(bankVersionId);
        }
        String expressionStr = expression.toString();
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            TradeDetailJson tradeDetailJson = this.toCurrentInfo(dynamicObject);
            tradeDetailJsonList.add(tradeDetailJson);
        }
        return tradeDetailJsonList;
    }

    private TradeDetailJson toCurrentInfo(DynamicObject dynamicObject) {
        TradeDetailJson info = new TradeDetailJson();
        info.setId(dynamicObject.getLong("id"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        info.setCustomNo(dynamicObject.getString("custom_id"));
        info.setDetailId(dynamicObject.getString("aqap_detail_id"));
        info.setBankVersionId(dynamicObject.getString("bank_version.number"));
        info.setJson(dynamicObject.getString("json"));
        return info;
    }

    private DynamicObject packCurrentInfo(DynamicObject dynamicObject, TradeDetailJson info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("aqap_detail_id", (Object)info.getDetailId());
        dynamicObject.set("json_tag", (Object)info.getJson());
        BankVersionRepository bankVersionRepository = SpringContextUtil.getBean(BankVersionRepository.class);
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        return dynamicObject;
    }

    private DynamicObject packCurrentInfo(DynamicObject dynamicObject, TradeDetailJson info, DynamicObject bankVersion) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("aqap_detail_id", (Object)info.getDetailId());
        dynamicObject.set("json_tag", (Object)info.getJson());
        dynamicObject.set("bank_version", (Object)bankVersion);
        return dynamicObject;
    }
}

