/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.testnet;

import kd.ebg.aqap.common.model.testnet.State;

public class Response {
    private final boolean connectSuccess;
    private String errMsg;
    private State state = State.INIT;
    private String errReason;
    private String localAddress;
    private String targetIp;
    private String port;

    public Response(boolean connectSuccess, String errMsg) {
        this.connectSuccess = connectSuccess;
        this.errMsg = errMsg;
    }

    public static Response success() {
        return new Response(true, "");
    }

    public static Response fail(String errMsg) {
        return new Response(false, errMsg);
    }

    public static Response fail() {
        return new Response(false, "");
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isSuccess() {
        return this.connectSuccess;
    }

    public boolean isCosmic2ProxyStopped() {
        return this.state == State.COSMIC2PROXY_ERROR;
    }

    public String getErrReason() {
        return this.errReason;
    }

    public void setErrReason(String errReason) {
        this.errReason = errReason;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public void setTargetIp(String targetIp) {
        this.targetIp = targetIp;
    }
}

