/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.security.proxy;

import java.io.FileInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import kd.ebg.aqap.common.security.proxy.ProxyException;
import org.bouncycastle.util.encoders.Base64;

public class ProxySignature {
    private String publicCertPath;
    private Signature signatureVerify;
    private PublicKey publicKey;
    private Signature signature;
    private PrivateKey privateKey;

    public ProxySignature(String publicCertPath) {
        this.publicCertPath = publicCertPath;
    }

    public ProxySignature(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public ProxySignature(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public void init() {
        try {
            String algid;
            if (Objects.isNull(this.publicKey)) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                try (FileInputStream fileInputStream = new FileInputStream(this.publicCertPath);){
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(fileInputStream);
                    this.publicKey = cert.getPublicKey();
                }
            }
            if (Objects.nonNull(this.publicKey)) {
                algid = this.publicKey.getAlgorithm();
                if ("RSA".equalsIgnoreCase(algid)) {
                    this.signatureVerify = Signature.getInstance("SHA256withRSA");
                } else if ("DSA".equalsIgnoreCase(algid)) {
                    this.signatureVerify = Signature.getInstance("SHA256withRSA");
                }
                this.signatureVerify.initVerify(this.publicKey);
            }
            if (Objects.nonNull(this.privateKey)) {
                algid = this.privateKey.getAlgorithm();
                if ("RSA".equalsIgnoreCase(algid)) {
                    this.signature = Signature.getInstance("SHA256withRSA");
                } else if ("DSA".equalsIgnoreCase(algid)) {
                    this.signature = Signature.getInstance("SHA256withRSA");
                }
                this.signature.initSign(this.privateKey);
            }
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
    }

    public synchronized boolean verify(String sign, byte[] content) {
        boolean flag = false;
        byte[] signedByte = Base64.decode((String)sign);
        try {
            this.signatureVerify.update(content);
            flag = this.signatureVerify.verify(signedByte);
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
        return flag;
    }

    public synchronized String sign(byte[] source) {
        String signedStr = null;
        byte[] result = null;
        try {
            this.signature.update(source);
            result = this.signature.sign();
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
        signedStr = Base64.toBase64String((byte[])result);
        return signedStr;
    }
}

