/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertReader {
    private KeyStore keyStore;
    private String certPath;
    private String certPd;
    private String alias;
    private InputStream stream;
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";
    private static String KEY_STORE_TYPE = "PKCS12";

    public CertReader(String certPath, String certPd, String alias) {
        this.certPath = certPath;
        this.certPd = certPd;
        this.alias = alias;
    }

    public CertReader(InputStream stream, String certPd, String alias) {
        this.stream = stream;
        this.certPd = certPd;
        this.alias = alias;
    }

    public static void setKeyStoreType(String type) {
        KEY_STORE_TYPE = type;
    }

    public PrivateKey getPrivateKey() throws Exception {
        return (PrivateKey)this.keyStore.getKey(this.getAlias(), this.certPd.toCharArray());
    }

    public PublicKey getPublicKey() throws Exception {
        return this.getCertificate().getPublicKey();
    }

    public String getAlias() throws Exception {
        if (null != this.alias && !"".equalsIgnoreCase(this.alias)) {
            return this.alias;
        }
        Enumeration<String> aliases = this.keyStore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }

    public void initKeyStore() throws Exception {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        if (null == this.stream) {
            this.stream = new FileInputStream(new File(this.certPath));
        }
        this.keyStore.load(this.stream, this.certPd.toCharArray());
        this.stream.close();
    }

    public Certificate getCertificate() throws Exception {
        return this.keyStore.getCertificate(this.getAlias());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPwd() {
        return this.certPd;
    }

    public void setCertPwd(String certPd) {
        this.certPd = certPd;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public static String getPKCS12() {
        return PKCS12;
    }

    public static String getJKS() {
        return JKS;
    }

    public static String getKeyStoreType() {
        return KEY_STORE_TYPE;
    }
}

