/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils.crypto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.privacy.service.PrivacyEncryptService;

public class PayPrivacyUtil {
    private static PrivacyEncryptService privacyService = new PrivacyEncryptService();

    public static PrivacyEncryptService getSingtonService() {
        if (privacyService == null) {
            privacyService = new PrivacyEncryptService();
            return privacyService;
        }
        return privacyService;
    }

    public static Map<String, Object> getPYDefaultValue(ISaveDataTable table) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (PayPrivacyUtil.isEnable()) {
            String tableName = table.getSchema().getName();
            Set encryptFields = PayPrivacyUtil.getSingtonService().getEncryptFields(tableName);
            if (table.getSaveRows().length > 0) {
                ISaveMetaRow saveRow = table.getSaveRows()[0];
                List columnValuePairList = saveRow.getDirtyValues();
                for (int i = 0; i < columnValuePairList.size(); ++i) {
                    DbMetadataColumn metadataColumn = ((IColumnValuePair)columnValuePairList.get(i)).getColumn();
                    String columnName = metadataColumn.getName();
                    if (!encryptFields.contains(columnName)) continue;
                    map.put(columnName, metadataColumn.getDefaultValue());
                }
            }
        }
        return map;
    }

    private static boolean isEnable() {
        String tenantId = RequestContext.get().getTenantId();
        return Boolean.parseBoolean(System.getProperty(tenantId + "_privacycenter.enable"));
    }
}

