/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils.gdbopa;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.common.utils.gdbopa.Hex;
import kd.ebg.aqap.common.utils.gdbopa.SM2KeyPair;
import kd.ebg.aqap.common.utils.gdbopa.SM2Util;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.log.EBGLogger;

public class GDBOpaSMUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GDBOpaSMUtil.class);

    public static Map<String, String> getSMKey() {
        SM2KeyPair pair = SM2Util.generateKeyPair();
        String publicKey = Hex.encode(pair.getPubKey());
        String privateKey = Hex.encode(pair.getPriKey());
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("publicKey", publicKey);
        result.put("privateKey", privateKey);
        return result;
    }

    public static void saveBankLoginCert(String publicKey, String privateKey, String bankVersionID, String bankLoginID, String customID) {
        String source = CertSource.SYSTEM.getSource() + "";
        String certType = CertTypeEnum.PLATEFORM.getType() + "";
        UserCertRepository userCertRepository = SpringContextUtil.getBean(UserCertRepository.class);
        DynamicObject[] dynamicObjects = userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
        DynamicObject privateDynamicObject = null;
        DynamicObject publicDynamicObject = null;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (OPAMetaDataTemplate.PublicKey.equalsIgnoreCase(dynamicObject.getString("bank_config_id"))) {
                    publicDynamicObject = dynamicObject;
                    continue;
                }
                if (!OPAMetaDataTemplate.PrivateKey.equalsIgnoreCase(dynamicObject.getString("bank_config_id"))) continue;
                privateDynamicObject = dynamicObject;
            }
        }
        if (privateDynamicObject == null) {
            userCertRepository.addBankLoginCert(OPAMetaDataTemplate.PrivateKey, ResManager.loadKDString((String)"\u5ba2\u6237\u79c1\u94a5\u6587\u4ef6", (String)"GDBOpaSMUtil_0", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, GDBOpaSMUtil.encryptCert(privateKey), "", source, certType);
        } else {
            userCertRepository.updateBankLoginCert(privateDynamicObject, OPAMetaDataTemplate.PrivateKey, ResManager.loadKDString((String)"\u5ba2\u6237\u79c1\u94a5\u6587\u4ef6", (String)"GDBOpaSMUtil_0", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, GDBOpaSMUtil.encryptCert(privateKey), "", source, certType);
        }
        if (publicDynamicObject == null) {
            userCertRepository.addBankLoginCert(OPAMetaDataTemplate.PublicKey, ResManager.loadKDString((String)"\u5ba2\u6237\u516c\u94a5\u6587\u4ef6", (String)"GDBOpaSMUtil_1", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, GDBOpaSMUtil.encryptCert(publicKey), "", source, certType);
        } else {
            userCertRepository.updateBankLoginCert(publicDynamicObject, OPAMetaDataTemplate.PublicKey, ResManager.loadKDString((String)"\u5ba2\u6237\u516c\u94a5\u6587\u4ef6", (String)"GDBOpaSMUtil_1", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, GDBOpaSMUtil.encryptCert(publicKey), "", source, certType);
        }
    }

    static String encryptCert(String certValue) {
        AESCipherSecurity cipherSecurity = SpringContextUtil.getBean(AESCipherSecurity.class);
        byte[] byteArray = certValue.getBytes();
        try {
            return cipherSecurity.encrypt(byteArray);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u94a5\u52a0\u5bc6\u5b58\u5e93\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bc6\u94a5\u52a0\u5bc6\u5b58\u5e93\u5f02\u5e38\u3002", (String)"GDBOpaSMUtil_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
    }
}

