/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nhb.dc.utils.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EActBalQry");
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element map = JDomUtils.addChild((Element)list, (String)"Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg})));
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :\u94f6\u884c\u8fd4\u56de<List>\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]));
        }
        Element map = (Element)list.getChildren().get(0);
        String returnCode = map.getChildTextTrim("ReturnCode");
        String returnMsg = map.getChildTextTrim("ReturnMsg");
        if (!"000000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnCode, returnMsg})));
        }
        String acNo = map.getChildTextTrim("AcNo");
        String currency = map.getChildTextTrim("Currency");
        String balance = map.getChildTextTrim("Balance");
        String availBal = map.getChildTextTrim("AvailBal");
        if (!acnt.getAccNo().equals(acNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u9519\u8bef :\u8fd4\u56de\u7684\u8d26\u53f7%1$s\u4e0d\u662f\u67e5\u8be2\u8d26\u53f7%2$s\u3002", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), acNo, acnt.getAccNo()));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(acnt);
        if (StringUtils.isEmpty((String)balance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankCurrency(currency);
        if (!StringUtils.isEmpty((String)availBal)) {
            balanceInfo.setAvailableBalance(new BigDecimal(availBal));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3.1 \u5e10\u6237\u4f59\u989d\u67e5\u8be2\uff08\u652f\u6301\u591a\u8d26\u53f7\uff09", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

