/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.services.payment.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nhb.dc.utils.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(SalaryQueryImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EAgentResultQry");
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"BatchId", (String)"");
        JDomUtils.addChild((Element)body, (String)"SubmitNo", (String)paymentInfos[0].getBankBatchSeqId());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"SalaryQueryImpl_5", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), iBSReturnCode, iBSReturnMsg));
        }
        Element body = root.getChild("Body");
        String contents = body.getChildTextTrim("Contents");
        String contentMsg = Packer.unCompress(contents);
        log.info("\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\uff1a" + contentMsg);
        String[] rows = StringUtils.split((String)contentMsg, (String)"\n");
        for (int i = 0; i < rows.length; ++i) {
            String[] cols = StringUtils.split((String)rows[i], (String)",");
            String listNo = cols[0];
            String returnCode = cols[4];
            String returnMsg = cols[5];
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)listNo);
            if (null == paymentInfo) continue;
            if ("0000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryImpl_2", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryImpl_3", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EAgentResultQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3.9 \u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\uff08\u4ea4\u6613\u7801B2EAgentResultQry\uff09", (String)"SalaryQueryImpl_4", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

