/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.payment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.PaymentStateEnum;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        return this.packCommonPay(paymentInfos);
    }

    public String packCommonPay(List<PaymentInfo> paymentInfos) {
        LoginUtils.getInstance().login();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSET35", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0120002", paymentInfos.get(0).getBankBatchSeqId());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "RvPy_Txn_TpCd", "01");
        JDomExtUtils.addChildCDData(request, "CstPty_Py_Jrnl_No", BizNoUtil.prefix_cont((String)paymentInfos.get(0).getBankDetailSeqId()));
        PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos.get(0));
        JDomExtUtils.addChildCDData(request, "Pyr_BkCgyCd", "01");
        JDomExtUtils.addChildCDData(request, "Pyr_Cst_AccNo", paymentInfos.get(0).getAccNo());
        JDomExtUtils.addChildCDData(request, "Pyr_AccNm", paymentInfos.get(0).getAccName());
        JDomExtUtils.addChildCDData(request, "Pyr_Acc_CgyCd", "02");
        JDomExtUtils.addChildCDData(request, "RcvPrt_BkCgyCd", paymentInfos.get(0).is2SameBank() ? "01" : "02");
        JDomExtUtils.addChildCDData(request, "RcvPrt_Cst_AccNo", paymentInfos.get(0).getIncomeAccNo());
        JDomExtUtils.addChildCDData(request, "RcvPrt_DpBkNm", paymentInfos.get(0).getIncomeBankName());
        JDomExtUtils.addChildCDData(request, "RcvPtAc_Nm", paymentInfos.get(0).getIncomeAccName());
        JDomExtUtils.addChildCDData(request, "RcvPrt_BnkCD", paymentInfos.get(0).getIncomeCnaps());
        JDomExtUtils.addChildCDData(request, "RcvPrt_Adr", paymentInfos.get(0).getIncomeBankAddress());
        JDomExtUtils.addChildCDData(request, "Rmrk", paymentInfos.get(0).getExplanation());
        JDomExtUtils.addChildCDData(request, "Py_Cnd_TpCd", "00");
        JDomExtUtils.addChildCDData(request, "RvPy_ExMd_Cd", "0");
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Dt", date);
        PaymentInfoSysFiled.set(paymentInfos, (String)"Cst_Dlv_Dt", (String)date);
        try {
            String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmssSSS"));
            JDomExtUtils.addChildCDData(request, "Cst_Dlv_Tm", time);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        JDomExtUtils.addChildCDData(request, "Rqs_Amt", paymentInfos.get(0).getAmount().toString());
        JDomExtUtils.addChildCDData(request, "Urgnt_TpCd", paymentInfos.get(0).is2Urgent() ? "02" : "01");
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        rspStr = CommonParser.preParse(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        CDBBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String headCode = JDomExtUtils.getChildText((Element)head, (String)"SYS_TX_STATUS");
        String resultCode = "";
        String bankMsg = "";
        String bankCode = "";
        if (null != response) {
            if (BankBusinessConfig.isJGAcc(((PaymentInfo)paymentInfos.get(0)).getAccNo()).booleanValue()) {
                resultCode = JDomExtUtils.getChildText((Element)response, (String)"Bsn_St_CD");
                PaymentStateEnum state = PaymentStateEnum.getEnumByTypeAndPid("P1G015011", resultCode);
                bankMsg = state.getBankMsg();
                bankCode = bankResp.getResponseCode();
            } else {
                resultCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Txn_Rslt_Cd");
                bankMsg = JDomExtUtils.getChildText((Element)response, (String)"Err_Inf");
                bankCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Err_Cd");
            }
        } else {
            bankMsg = bankResp.getBankMsg();
            bankCode = bankResp.getResponseCode();
        }
        if ("00".equals(headCode)) {
            String typeCode = "P1CMSET35";
            if (BankBusinessConfig.isJGAcc(((PaymentInfo)paymentInfos.get(0)).getAccNo()).booleanValue()) {
                typeCode = "P1G015011";
            }
            if (!StringUtils.isEmpty((String)resultCode)) {
                PaymentStateEnum stateEnum = PaymentStateEnum.getEnumByTypeAndPid(typeCode, resultCode);
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)stateEnum.getState(), (String)stateEnum.getEnName(), (String)bankCode, (String)stateEnum.getBankMsg());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSET35";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u666e\u901a\u6237\u652f\u4ed8\u8f6c\u8d26", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String accNo = paymentInfo.getAccNo();
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isJGAcc(accNo) == false;
    }
}

