/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.payment;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.PayParseUtil;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.getInstance().login();
        PaymentInfo info = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSET36", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0220001", info.getBankBatchSeqId());
        body.addContent((Content)request);
        String Cst_Dlv_Dt = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"Cst_Dlv_Dt");
        if (StringUtils.isEmpty((String)Cst_Dlv_Dt)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"QueryPaymentImpl_9", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
        }
        JDomExtUtils.addChildCDData(request, "Enqr_StDt", Cst_Dlv_Dt);
        JDomExtUtils.addChildCDData(request, "Enqr_CODt", Cst_Dlv_Dt);
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        rspStr = CommonParser.preParse(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        CDBBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        if (!"0".equals(recNum)) {
            List resultList = response.getChildren("LIST1");
            Map<String, CDBBankResponse> bankResponse = PayParseUtil.getParseredPayStatus(resultList);
            for (PaymentInfo info : paymentInfos) {
                CDBBankResponse resultCode = bankResponse.get(BizNoUtil.prefix_cont((String)info.getBankDetailSeqId()));
                if (null == resultCode) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u7ed3\u679c\u660e\u7ec6", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isSuccess()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isSubmited()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPaymentImpl_4", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPaymentImpl_4", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isUnkown()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPaymentImpl_5", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPaymentImpl_5", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPaymentImpl_6", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)resultCode.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u3002", (String)"QueryPaymentImpl_7", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSET36";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u666e\u901a\u6237\u67e5\u8be2\u8f6c\u8d26\u3002", (String)"QueryPaymentImpl_8", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }
}

