/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uob.dc.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uob.dc.services.Api;
import kd.ebg.aqap.banks.uob.dc.utils.UOBUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            String requestStr = this.pack(request);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            Preconditions.checkNotNull((Object)requestStr, (Object)MultiLang.getBankRequestDataEmptyTip());
            String response = UOBUtil.request((HttpRequestBase)new HttpGet(UOBUtil.url(Api.BALANCE.getName())), UOBUtil.generateJWT(requestStr));
            return this.parse(request, response);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        JSONObject root = new JSONObject();
        root.put("transactionReference", (Object)Sequence.gen16Sequence());
        JSONArray accounts = new JSONArray();
        JSONObject account = new JSONObject();
        account.put("accountNumber", (Object)acnt.getAccNo());
        account.put("accountCurrency", (Object)bankBalanceRequest.getBankCurrency());
        account.put("accountType", (Object)BankAcntPropertyConfig.getAccType((String)acnt.getAccNo()));
        accounts.add((Object)account);
        root.put("accounts", (Object)accounts);
        String r = root.toJSONString();
        logger.info("Payload\u4e3a{}", (Object)r);
        return r;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        JSONObject root = JSONObject.parseObject((String)s);
        JSONArray accounts = root.getJSONArray("accounts");
        if (accounts == null || accounts.isEmpty()) {
            logger.info("accounts {}", (Object)accounts);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8d26\u6237\u4f59\u989d\u4fe1\u606f\u3002", (String)"", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]));
        }
        JSONObject account = accounts.getJSONObject(0);
        JSONObject availableBalance = account.getJSONObject("availableBalance");
        BigDecimal availableBalanceMoney = availableBalance.getBigDecimal("amount");
        JSONObject accountBalance = account.getJSONObject("accountBalance");
        BigDecimal accountBalanceMoney = accountBalance.getBigDecimal("amount");
        BalanceInfo info = new BalanceInfo();
        info.setBankCurrency(bankBalanceRequest.getBankCurrency());
        info.setBankAcnt(bankBalanceRequest.getAcnt());
        info.setCurrentBalance(accountBalanceMoney);
        info.setAvailableBalance(availableBalanceMoney);
        info.setBalanceDateTime(LocalDateTime.now());
        balanceInfos.add(info);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

