/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment.authorized;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.service.payment.authorized.AuthorizedQueryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.banks.gdb.dc.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthorizedPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorizedQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "0044";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7f51\u94f6\u6388\u6743\u4ea4\u6613\uff08\u4ea4\u6613\u78010044\uff09\u3002", (String)"AuthorizedPayImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return BankBusinessConfig.isPaymetByAuthorized();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0044", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"tranType", (String)"0");
            JDomUtils.addChild((Element)body, (String)"isEntBankCheck", (String)"0");
            JDomUtils.addChild((Element)body, (String)"outAccName", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)body, (String)"outAcc", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)body, (String)"inAccName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)body, (String)"inAcc", (String)paymentInfo.getIncomeAccNo().replaceAll("\u200b", ""));
            JDomUtils.addChild((Element)body, (String)"inAccBank", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)body, (String)"inAccAdd", (String)(paymentInfo.getIncomeProvince() + "/" + paymentInfo.getIncomeCity()));
            JDomUtils.addChild((Element)body, (String)"paymentBankid");
            JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)body, (String)"remark", (String)AuthorizedPayImpl.getFixedExplanation(paymentInfo.getExplanation(), 22));
            JDomUtils.addChild((Element)body, (String)"comment", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)body, (String)"reserve1");
            JDomUtils.addChild((Element)body, (String)"reserve2");
            JDomUtils.addChild((Element)body, (String)"reserve3");
            JDomUtils.addChild((Element)body, (String)"reserve4");
            JDomUtils.addChild((Element)body, (String)"reserve5");
        } else {
            JDomUtils.addChild((Element)body, (String)"tranType", (String)"1");
            JDomUtils.addChild((Element)body, (String)"isEntBankCheck", (String)"0");
            JDomUtils.addChild((Element)body, (String)"outAccName", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)body, (String)"outAcc", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)body, (String)"inAccName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)body, (String)"inAcc", (String)paymentInfo.getIncomeAccNo().replaceAll("\u200b", ""));
            JDomUtils.addChild((Element)body, (String)"inAccBank", (String)paymentInfo.getIncomeBankName());
            String individualFlag = paymentInfo.is2Individual() ? "1" : "0";
            String cityFlag = paymentInfo.is2SameCity() ? "0" : "2";
            JDomUtils.addChild((Element)body, (String)"inAccAdd", (String)(individualFlag + "1" + cityFlag + "0" + paymentInfo.getIncomeProvince() + "/" + paymentInfo.getIncomeCity()));
            JDomUtils.addChild((Element)body, (String)"paymentBankid", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)body, (String)"remark", (String)AuthorizedPayImpl.getFixedExplanation(paymentInfo.getExplanation(), 22));
            JDomUtils.addChild((Element)body, (String)"comment", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)body, (String)"reserve1");
            JDomUtils.addChild((Element)body, (String)"reserve2");
            JDomUtils.addChild((Element)body, (String)"reserve3");
            JDomUtils.addChild((Element)body, (String)"reserve4");
            JDomUtils.addChild((Element)body, (String)"reserve5");
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String getFixedExplanation(String explanation, int formatLength) {
        if (StringUtils.isEmpty((String)explanation)) {
            return "";
        }
        if (explanation.length() > formatLength) {
            return explanation.substring(0, formatLength);
        }
        return explanation;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"AuthorizedPayImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        String status = JDomUtils.getChildText((Element)body, (String)"status");
        if ("2".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"2", (String)ResManager.loadKDString((String)"\u4ee3\u6388\u6743", (String)"AuthorizedPayImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

