/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment.company.otherBank;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.util.KDUtil;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.banks.gdb.dc.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NoForceCompanyPaymentImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "0021";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u5bf9\u516c\u3001\u5bf9\u79c1\u652f\u4ed8(\u975e\u5f3a\u5236\u843d\u5730)", (String)"NoForceCompanyPaymentImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay_for_linkpay".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createRootNode();
        Element message = new Element("message");
        message = Packer.createMessageNode(root, "0021", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"outAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"outAcc", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"inAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"inAcc", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"inAccBank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"inAccAdd", (String)(paymentInfo.getIncomeProvince() + " " + paymentInfo.getIncomeCity()));
        JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().setScale(2, 1).toString());
        String remark = NoForceCompanyPaymentImpl.getFixedExplanation(paymentInfo.getExplanation(), 100);
        JDomUtils.addChild((Element)body, (String)"remark", (String)KDUtil.getKDStr(paymentInfo));
        JDomUtils.addChild((Element)body, (String)"comment", (String)remark);
        if (StringUtils.isEmpty((String)paymentInfo.getIncomeCnaps())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c\u7684\u2018\u8de8\u884c\u4e0d\u843d\u5730\u4ea4\u6613(0021)\u2019,\u6536\u6b3e\u65b9\u7684\u8054\u884c\u53f7\u5fc5\u586b!", (String)"NoForceCompanyPaymentImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"paymentBankid", (String)paymentInfo.getIncomeCnaps());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String getFixedExplanation(String explanation, int formatLength) {
        if (StringUtils.isEmpty((String)explanation)) {
            return "";
        }
        if (explanation.length() > formatLength) {
            return explanation.substring(0, formatLength);
        }
        return explanation;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

