/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment.salary;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.gdb.dc.util.KDUtil;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.banks.gdb.dc.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "0019";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_salary".equalsIgnoreCase(info.getSubBizType()) && !BankBusinessConfig.isPaymetByAuthorized();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0019", paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"customerBatchNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"allCount", (String)Integer.toString(paymentInfos.length));
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmount = totalAmount.add(paymentInfos[i].getAmount());
        }
        JDomUtils.addChild((Element)body, (String)"allSalary", (String)totalAmount.setScale(2, 1).toString());
        Element records = JDomUtils.addChild((Element)body, (String)"records");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element record = JDomUtils.addChild((Element)records, (String)"record");
            PaymentInfo info = paymentInfos[i];
            JDomUtils.addChild((Element)record, (String)"customerSalarySeq", (String)info.getBankDetailSeqId());
            if ("0".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo()))) {
                JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "0" : "1"));
            } else if ("1".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo()))) {
                JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "2" : "3"));
            } else if ("2".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo()))) {
                JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "4" : "5"));
            } else if ("3".equalsIgnoreCase(BankBusinessConfig.getIndividualType(paymentInfo.getAccNo()))) {
                if (paymentInfo.getExplanation().indexOf(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0])) != -1) {
                    JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "0" : "1"));
                } else if (paymentInfo.getExplanation().indexOf(ResManager.loadKDString((String)"\u62a5\u9500", (String)"SalaryPayImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0])) != -1) {
                    JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "2" : "3"));
                } else {
                    JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "4" : "5"));
                }
            } else {
                JDomUtils.addChild((Element)record, (String)"transType", (String)(info.is2SameBank() ? "4" : "5"));
            }
            JDomUtils.addChild((Element)record, (String)"employeeNo", (String)Integer.toString(i));
            JDomUtils.addChild((Element)record, (String)"employeeName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)record, (String)"employeeAccount", (String)info.getIncomeAccNo().replaceAll("\u200b", ""));
            JDomUtils.addChild((Element)record, (String)"bankName", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)record, (String)"bankCode", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)record, (String)"salary", (String)info.getAmount().setScale(2, 1).toString());
            String remark = info.getExplanation();
            String kdStr = KDUtil.getKDStr(info);
            try {
                if (remark == null) {
                    remark = kdStr;
                } else if (remark.getBytes(RequestContextUtils.getCharset()).length + kdStr.getBytes(RequestContextUtils.getCharset()).length < 50) {
                    remark = kdStr + remark;
                } else {
                    log.info("\u6458\u8981\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u65e0\u6cd5\u6dfb\u52a0kd\u6807\u8bb0\uff0c\u65e0\u6cd5\u5bf9\u8d26");
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u4e0d\u652f\u6301\u7684\u7f16\u53f7", (Throwable)e);
            }
            JDomUtils.addChild((Element)record, (String)"remark", (String)remark);
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryPayImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPayImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

