/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        EBBankBalanceResponse response = null;
        for (BankAcnt bankAcnt : bankAcntList) {
            try {
                request.getHeader().setAcnt(bankAcnt);
                response = this.doBiz(request);
                balanceInfos.addAll(response.getBalances());
            }
            catch (EBServiceException e) {
                logger.info("\u4eca\u65e5\u4f59\u989d\u67e5\u8be2\u51fa\u9519\uff1a", (Object)e);
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(bankAcnt);
                balanceInfo.setBankCurrency(request.getBankCurrency());
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4eca\u65e5\u4f59\u989d\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getCause()));
                balanceInfos.add(balanceInfo);
            }
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest rqst) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
        BankAcnt acnt = rqst.getAcnt();
        String branchNo = AreaCodeImpl.getInstance().getAreaCode(acnt);
        JSONObject ntqacinfx = new JSONObject();
        ntqacinfx.put("accnbr", (Object)rqst.getAcnt().getAccNo());
        ntqacinfx.put("bbknbr", (Object)branchNo);
        ntqacinfx.put("ccynbr", (Object)rqst.getBankCurrency());
        JSONArray array = new JSONArray();
        array.add((Object)ntqacinfx);
        JSONObject body = new JSONObject();
        body.put("ntqacinfx", (Object)array);
        String bizCode = "NTQACINF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
        String res = MsgParser.getReceMsg(rspStr, logger);
        return this.parse(res, rqst.getBankAcntList());
    }

    public EBBankBalanceResponse parse(String res, List<BankAcnt> bankAcntList) {
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqacinfz = body.getJSONArray("ntqacinfz");
        BalanceInfo[] balances = new BalanceInfo[1];
        for (int i = 0; i < ntqacinfz.size(); ++i) {
            JSONObject detail = ntqacinfz.getJSONObject(i);
            String ccynbr = detail.getString("ccynbr");
            String accnbr = detail.getString("accnbr");
            String accblv = detail.getString("accblv");
            String avlblv = detail.getString("avlblv");
            String onlblv = detail.getString("onlblv");
            String hldblv = detail.getString("hldblv");
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u4e0a\u65e5\u4f59\u989d'\u4e3a" + accblv);
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u8054\u673a\u4f59\u989d'\u4e3a" + onlblv);
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + avlblv);
            balances[0] = new BalanceInfo();
            this.setBankAcnt(balances[0], bankAcntList, accnbr);
            this.setBankCurrency(balances[0], ccynbr);
            this.setBalanceDateTime(balances[0], LocalDateTime.now());
            this.setCurrentBalance(balances[0], onlblv);
            this.setLastDayAvlBalance(balances[0], accblv);
            this.setAvailableBalance(balances[0], avlblv);
            this.setFreezeBalance(balances[0], hldblv);
            String intcod = detail.getString("intcod");
            if ("S".equals(intcod)) {
                this.setDepositBalance(balances[0], accblv);
            }
            if (!"S".equals(intcod) || !BankBusinessConfig.isChooseAccblv()) continue;
            this.setAvailableBalance(balances[0], accblv);
        }
        ArrayList balanceInfoList = new ArrayList(balances.length);
        Collections.addAll(balanceInfoList, balances);
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return "H";
    }

    public String getBizCode() {
        return "NTQACINF";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"5.1.3\u8d26\u6237\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2(NTQACINF)", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

