/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BusModUtil {
    public static String packSearch(String code) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(BusModUtil.class);
        JSONObject body = new JSONObject();
        body.put("buscod", (Object)code);
        String bizCode = "DCLISMOD";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public static String getBusMod(String code) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(BusModUtil.class);
        String rqstStr = BusModUtil.packSearch(code);
        String rspStr = PostUtil.sendMsg(rqstStr);
        if (StringUtils.isNotEmpty((String)rspStr)) {
            BankResponse response = MsgParser.getResponse(rspStr = MsgParser.getReceMsg(rspStr, logger), logger);
            if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"BusModUtil_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
            }
            JSONObject request = JSONObject.parseObject((String)rspStr);
            JSONObject resp = request.getJSONObject("response");
            JSONObject body = resp.getJSONObject("body");
            JSONArray array = body.getJSONArray("ntqmdlstz");
            if (array == null || array.size() == 0) {
                return "";
            }
            if (array != null && array.size() == 1) {
                JSONObject object = (JSONObject)array.get(0);
                return object.getString("busmod");
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                result.append(object.getString("busmod"));
                if (i >= array.size() - 1) continue;
                result.append(',');
            }
            return result.toString();
        }
        return null;
    }

    public static String getSerialNo(String no) {
        if (no.length() == 1) {
            return "0000000" + no;
        }
        if (no.length() == 2) {
            return "000000" + no;
        }
        if (no.length() == 3) {
            return "00000" + no;
        }
        if (no.length() == 4) {
            return "0000" + no;
        }
        if (no.length() == 5) {
            return "000" + no;
        }
        if (no.length() == 6) {
            return "00" + no;
        }
        if (no.length() == 7) {
            return "0" + no;
        }
        return no;
    }
}

