/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.util.Check;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final Logger logger = LoggerFactory.getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        if (BankBusinessConfig.isFixedAcnt(request.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = BOCOM_DC_Packer.packRoot("310106");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"accNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        Check.checkResponseCode(rsp, "0000");
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = serial_record.split("\\|");
        Object[] balances = new BalanceInfo[recordNum];
        for (int i = 1; i <= recordNum; ++i) {
            String accNo = splits[fieldNum * i + 1];
            String currency = splits[fieldNum * i + 4];
            String balanceStr = splits[fieldNum * i + 6];
            String availableBalanceStr = splits[fieldNum * i + 6];
            String transDate = splits[fieldNum * i + 5];
            balances[i - 1] = new BalanceInfo();
            this.setCurrentBalance((BalanceInfo)balances[i - 1], balanceStr.trim());
            this.setAvailableBalance((BalanceInfo)balances[i - 1], availableBalanceStr.trim());
            this.setBankCurrency((BalanceInfo)balances[i - 1], currency);
            this.setBankAcnt((BalanceInfo)balances[i - 1], request.getBankAcntList(), accNo);
            this.setBalanceDateTime((BalanceInfo)balances[i - 1], transDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])balances));
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(29L);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "310106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }
}

