/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.company.AuthorizedPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.SingleIndividualPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.FastPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SingleFastPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SingleSlowPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SlowPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank.BatchPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank.SinglePayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.interface210234.PayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.otherbank.InternetBankPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.oversea.OverSeaPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (this.isPay(paymentInfo)) {
            if (this.isTransferUseCN(paymentInfo)) {
                this.setAllocationPay(paymentInfo);
            } else if (this.isSameBank(paymentInfo)) {
                if (this.isSameBankPay210234()) {
                    this.setImplClassName(paymentInfo, PayImpl.class.getName());
                } else {
                    this.setCommonPay(paymentInfo);
                }
            } else if (this.isSupportSuperBanK()) {
                this.setImplClassName(paymentInfo, InternetBankPayImpl.class.getName());
            } else if (this.isOtherBankPay210234()) {
                this.setImplClassName(paymentInfo, PayImpl.class.getName());
            } else {
                this.setCommonPay(paymentInfo);
            }
        } else if (this.isPay_for_salary(paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            this.setCommonPay(paymentInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setAllocationPay(paymentInfo);
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setCompanyPay(paymentInfo);
        } else if (this.isPay_for_overseaPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, OverSeaPayImpl.class.getName());
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        return busiImplInfo;
    }

    private boolean isOtherBankPay210229() {
        return this.assertBusinessConfig("PAYMENT_OTHER_INDIVIDUAL_CHOOSE", "210229");
    }

    private boolean isOtherBankPay210201() {
        return this.assertBusinessConfig("PAYMENT_OTHER_INDIVIDUAL_CHOOSE", "210201");
    }

    private boolean isSameBankPay210234() {
        return this.assertBusinessConfig("bocom_dc_payment_model", "pay210234");
    }

    private boolean isOtherBankPay210234() {
        return this.assertBusinessConfig("PAYMENT_OTHER_BANK_CONFIG", "pay210234");
    }

    private boolean isSupportSuperBanK() {
        return this.assertBusinessConfig("PAYMENT_OTHER_BANK_CONFIG", "pay210224");
    }

    private boolean isAllocationToCompanyPay() {
        return this.assertBusinessConfig("boocm_dc_isallocationtocompany", "210201");
    }

    private boolean isPaymetByAuthorized() {
        return this.assertBusinessConfig("bocom_dc_payment_model", "payment_authorized");
    }

    private void setAllocationPay(PaymentInfo paymentInfo) {
        paymentInfo.setIndividual(Boolean.valueOf(false));
        if (this.isSameBank(paymentInfo)) {
            if (this.isAllocationToCompanyPay()) {
                this.setCompanyPay(paymentInfo);
            } else {
                this.setImplClassName(paymentInfo, AllocationPayImpl.class.getName());
            }
        } else {
            this.setCompanyPay(paymentInfo);
        }
    }

    private void setCommonPay(PaymentInfo paymentInfo) {
        if (this.isIndividual(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                this.setIndividualAndSalaryPay(paymentInfo);
            } else if (this.isOtherBankPay210229()) {
                if (paymentInfo.is2Merge()) {
                    this.setImplClassName(paymentInfo, BatchPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, SinglePayImpl.class.getName());
                }
            } else if (this.isOtherBankPay210201()) {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
                paymentInfo.setReversed4("payment_normal");
            } else if (PayTypeEnum.PAY_FOR_SALARY.getName().equalsIgnoreCase(paymentInfo.getSubBizType())) {
                if (paymentInfo.is2Merge()) {
                    this.setImplClassName(paymentInfo, BatchPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, SinglePayImpl.class.getName());
                }
            } else {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
                paymentInfo.setReversed4("payment_normal");
            }
        } else {
            this.setCompanyPay(paymentInfo);
        }
    }

    private void setCompanyPay(PaymentInfo paymentInfo) {
        if (this.isPaymetByAuthorized()) {
            this.setImplClassName(paymentInfo, AuthorizedPayImpl.class.getName());
            paymentInfo.setReversed4("payment_authorized");
        } else {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            paymentInfo.setReversed4("payment_normal");
        }
    }

    private void setIndividualAndSalaryPay(PaymentInfo paymentInfo) {
        if (this.isPaymetByAuthorized()) {
            if (this.isUrgent(paymentInfo)) {
                if (this.isMerge(paymentInfo)) {
                    this.setImplClassName(paymentInfo, FastPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, SingleFastPayImpl.class.getName());
                }
            } else if (this.isMerge(paymentInfo)) {
                this.setImplClassName(paymentInfo, SlowPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, SingleSlowPayImpl.class.getName());
            }
        } else if (this.isMerge(paymentInfo)) {
            this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, SingleIndividualPayImpl.class.getName());
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

