/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.PayPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "330003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1/\u5bf9\u79c1\u652f\u4ed8 \u975e\u5b9e\u65f6", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return info.is2Individual() && !"income".equalsIgnoreCase(info.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        try {
            String requestStr = PayPacker.pay330003(request.getPaymentInfoAsArray());
            return requestStr;
        }
        catch (Exception e) {
            this.logger.error("\u6253\u5305\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

