/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "310200";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = BOCOM_DC_Packer.packRoot("310200");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"ogl_serial_no", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"query_flag", (String)"1");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25   ", (String)"IndividualQueryPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int fieldNum = Integer.parseInt(field_num);
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25 \uff1a310207\u4ea4\u6613\u8fd4\u56de\u8bb0\u5f55\u6570\u4e3a0\u6761,\u65e0\u6cd5\u786e\u8ba4\u5f53\u524d\u4ea4\u6613\u72b6\u6001", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        String[] splits = StringUtils.split((String)serial_record, (String)"|");
        if (paymentInfos[0].is2Merge()) {
            return this.parseMerge(request, splits, fieldNum, recordNum);
        }
        return this.parseNotMerge(request, splits, fieldNum, recordNum);
    }

    private EBBankPayResponse parseMerge(BankPayRequest request, String[] splits, int fieldNum, int recordNum) {
        List paymentInfoAll = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfoAll);
        List paymentInfos1 = request.getPaymentInfos();
        HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos1) {
            String keyByPaymentInfo = PayStatusMatchUtil.getKeyByPaymentInfo((PaymentInfo)paymentInfo, (boolean)false, (boolean)false);
            paymentInfoMap.put(keyByPaymentInfo, paymentInfo);
        }
        for (int i = 1; i <= recordNum; ++i) {
            String payAmount = splits[fieldNum * i + 9];
            String inAcntNo = splits[fieldNum * i + 10];
            String inAnctName = splits[fieldNum * i + 11];
            String stat = splits[fieldNum * i + 12];
            String errorMessage = splits[fieldNum * i + 13];
            if (StringUtils.isEmpty((String)payAmount)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u901a\u94f6\u884c\u4ee3\u53d1\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\uff0c\u8fd4\u56de\u7684\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"IndividualQueryPayImpl_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
            }
            String key = this.selectPaymentKey(inAcntNo, inAnctName, payAmount);
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(key);
            if (null == paymentInfo) continue;
            this.handlePayStatus(paymentInfo, stat, errorMessage);
        }
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos1, (boolean)false, (boolean)false);
        this.processingBankItemDataHandler(splits, fieldNum, recordNum);
        PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos1, (boolean)false, (boolean)false);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private EBBankPayResponse parseNotMerge(BankPayRequest request, String[] splits, int fieldNum, int recordNum) {
        for (int i = 1; i <= recordNum; ++i) {
            String stat = splits[fieldNum * i + 12];
            String errorMessage = splits[fieldNum * i + 13];
            String bankDetailSeqId = splits[fieldNum * i + 14];
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)request.getPaymentInfos(), (String)bankDetailSeqId);
            if (paymentInfo == null) continue;
            this.handlePayStatus(paymentInfo, stat, errorMessage);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private void processingBankItemDataHandler(String[] splits, int fieldNum, int recordNum) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 1; i <= recordNum; ++i) {
                    String payAmount = splits[fieldNum * i + 9];
                    String inAcntNo = splits[fieldNum * i + 10];
                    String inAnctName = splits[fieldNum * i + 11];
                    String stat = splits[fieldNum * i + 12];
                    String errorMessage = splits[fieldNum * i + 13];
                    String bankDataKey = this.selectPaymentKey(inAcntNo, inAnctName, payAmount);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, stat, errorMessage);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private void handlePayStatus(PaymentInfo paymentInfo, String stat, String errorMessage) {
        if ("F".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_6", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_6", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        } else if ("E".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualQueryPayImpl_7", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)stat, (String)errorMessage);
        } else if ("0".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualQueryPayImpl_8", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)stat, (String)errorMessage);
        } else if ("3".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8bb0\u5f55\u53ef\u7591\uff0c\u8bf7\u786e\u8ba4\u8be5\u7b14\u4ea4\u6613\u3002", (String)"IndividualQueryPayImpl_4", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)stat, (String)errorMessage);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8fd4\u56de\u672a\u77e5\u4ed8\u6b3e\u72b6\u6001:%1$s\u3002", (String)"IndividualQueryPayImpl_9", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), stat), (String)stat, (String)errorMessage);
        }
    }

    public String selectPaymentKey(String incomeAccNo, String incomeAccName, String amount) {
        BigDecimal bigDecimal = new BigDecimal(amount).setScale(2);
        StringBuilder buffer = new StringBuilder();
        buffer.append(incomeAccNo).append(incomeAccName).append(bigDecimal.toPlainString());
        return buffer.toString();
    }
}

