/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.otherbank;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InternetBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = BOCOM_DC_Packer.packRoot("210224");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"partyid", (String)InternetBankPayImpl.getBankNo(paymentInfo.getIncomeBankName()));
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"summary", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"InternetBankPayImpl_2", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "210224";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u652f\u4ed8\u4ea4\u6613\uff08\u8d85\u7ea7\u7f51\u94f6\uff09", (String)"InternetBankPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public static String getBankNo(String bankName) {
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        String recBankNo = settBankKeyWordsRepository.matchBankNoByKey(bankName);
        if (StringUtils.isEmpty((String)recBankNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u94f6\u884c%s\u7684\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7,\u8bf7\u5728\u6e05\u7b97\u884c\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u6e05\u7b97\u884c\u53f7", (String)"InternetBankPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), bankName));
        }
        return recBankNo;
    }
}

