/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.detail;

import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.czccb.dc.service.Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailParser {
    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailParser.class);
        List<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        BankResponse rsp = Parser.parseResponse(rspStr);
        if ("000000".equalsIgnoreCase(rsp.getResponseCode())) {
            detailInfoList = this.getDetail(rspStr, rqst.getAcnt());
        }
        return detailInfoList;
    }

    public List<DetailInfo> getDetail(String rspStr, BankAcnt reqAcnt) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailParser.class);
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1, rspStr.length());
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        try {
            Element bankDate = JDomUtils.string2Root((String)body, (String)"UTF-8");
            Element opRep = bankDate.getChild("opRep");
            Element opResult = opRep.getChild("opResult");
            Element list = opResult.getChild("list");
            List rows = list.getChildren();
            DetailInfo detailInfo = null;
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (Element row : rows) {
                detailInfo = new DetailInfo();
                String transferDate = row.getChildText("transferDate");
                String vouchersNo = row.getChildText("vouchersNo");
                String recAccount = row.getChildText("recAccount");
                String recAccountName = row.getChildText("recAccountName");
                String recAccountOpenNode = row.getChildText("recAccountOpenNode");
                String transferTime = row.getChildText("transferTime");
                String balance = row.getChildText("balance");
                String loanFlag = row.getChildText("loanFlag");
                String transferSum = row.getChildText("transferSum");
                String transferNode = row.getChildText("transferNode");
                String currencyType = row.getChildText("currencyType");
                String resume = row.getChildText("resume");
                String transferFlowNo = row.getChildText("transferFlowNo");
                String tellerNo = row.getChildText("tellerNo");
                String seqNo = row.getChildText("seqNo");
                if ("D".equalsIgnoreCase(loanFlag)) {
                    detailInfo.setDebitAmount(new BigDecimal(transferSum));
                    detailInfo.setCreditAmount(BigDecimal.valueOf(0.0));
                } else {
                    detailInfo.setDebitAmount(BigDecimal.valueOf(0.0));
                    detailInfo.setCreditAmount(new BigDecimal(transferSum));
                }
                detailInfo.setAccNo(reqAcnt.getAccNo());
                detailInfo.setAccName(reqAcnt.getAccName());
                detailInfo.setBankName(reqAcnt.getBankName());
                detailInfo.setBankVersionID(reqAcnt.getBankVersionId());
                detailInfo.setBankLoginID(reqAcnt.getBankLoginId());
                detailInfo.setCurrency(currencyType);
                detailInfo.setBalance(new BigDecimal(balance));
                detailInfo.setBankDetailNo(transferFlowNo);
                if (!StringUtils.isEmpty((String)transferDate)) {
                    try {
                        detailInfo.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                        if (!StringUtils.isEmpty((String)transferTime)) {
                            detailInfo.setTransTime(DateTimeUtils.parseDate((String)(transferDate + transferTime.replaceAll(":", "")), (String)"yyyyMMddHHmmss").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        }
                        detailInfo.setTransTime(DateTimeUtils.parseDate((String)(transferDate + "000000"), (String)"yyyyMMddHHmmss").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                    }
                    catch (ParseException e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a%s\u3002", (String)"HisDetailParser_3", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                    }
                } else {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"HisDetailParser_1", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]));
                }
                if (!StringUtils.isEmpty((String)balance)) {
                    detailInfo.setBalance(new BigDecimal(balance));
                } else {
                    detailInfo.setBalance(BigDecimal.valueOf(0.0));
                }
                detailInfo.setOppAccNo(recAccount);
                detailInfo.setOppAccName(recAccountName);
                detailInfo.setOppBankName(recAccountOpenNode);
                detailInfo.setExplanation(resume);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detailInfo.setJsonMap(jsonStr);
                String accNo = reqAcnt.getAccNo();
                String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                detailInfos.add(detailInfo);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u62a5\u6587\u5931\u8d25--%s\u3002", (String)"HisDetailParser_4", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), body), (Throwable)e);
        }
        return detailInfos;
    }
}

