/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.payment.individual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.czccb.dc.service.payment.individual.PayPacker;
import kd.ebg.aqap.banks.czccb.dc.service.payment.individual.PayParser;
import kd.ebg.aqap.banks.czccb.dc.service.payment.individual.QueryIndividualPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IndividualPaymentImpl
extends AbstractPayImpl
implements IPay {
    private PayPacker payPacker = new PayPacker();
    private PayParser payParser = new PayParser();

    public String getDeveloper() {
        return "Kingdee";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613 \u4ee3\u53d1\u5de5\u8d44", (String)"IndividualPaymentImpl_0", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String userName = RequestContextUtils.getBankParameterValue((String)" user_name");
        String orderFlowNo = (StringUtils.isEmpty((String)userName) ? "CYJT" : userName) + paymentInfos[0].getBankDetailSeqID();
        paymentInfos[0].setBankRefID(orderFlowNo);
        return this.payPacker.packPay(paymentInfos);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        this.payParser.parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryIndividualPaymentImpl.class;
    }

    public boolean match(PaymentInfo info) {
        return info.is2Individual() && !"income".equalsIgnoreCase(info.getSubBizType());
    }
}

