/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.InternalTrans;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.InternalTrans.InternalTransQueryPayImpl;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InternalTransPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(InternalTransPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InternalTransQueryPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            la.getToken();
            Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead(paymentInfos[0].getPackageId());
            Element Tx = new Element("Tx");
            Element TransferREQ = new Element("TransferREQ");
            Element Requests = new Element("Requests");
            int num = paymentInfos.length;
            Requests.setAttribute("noOfRecord", Integer.toString(num));
            for (int i = 0; i < num; ++i) {
                Element Record = new Element("Record");
                Element InternalTrans = new Element("InternalTrans");
                JDomUtils.addChild((Element)InternalTrans, (String)"DDebitAcctNo", (String)paymentInfos[i].getAccNo());
                JDomUtils.addChild((Element)InternalTrans, (String)"DDebitCur", (String)paymentInfos[i].getCurrency());
                if (!BOCHK_DC_Packer.isBelowZero(paymentInfos[i].getAmount())) {
                    JDomUtils.addChild((Element)InternalTrans, (String)"DebitAmt", (String)paymentInfos[i].getAmount().setScale(2).toString());
                } else {
                    JDomUtils.addChild((Element)InternalTrans, (String)"DebitAmt", (String)"");
                }
                JDomUtils.addChild((Element)InternalTrans, (String)"BeneAcctNo", (String)paymentInfos[i].getIncomeAccNo());
                JDomUtils.addChild((Element)InternalTrans, (String)"BeneAcctName", (String)paymentInfos[i].getIncomeAccName());
                JDomUtils.addChild((Element)InternalTrans, (String)"PaymentCur", (String)paymentInfos[i].getPayCurrency());
                if (BankBusinessConfig.getBOC_HK_IS_NEED_ACTUAL() && !BOCHK_DC_Packer.isBelowZero(paymentInfos[i].getActualAmount())) {
                    JDomUtils.addChild((Element)InternalTrans, (String)"EquvAmt", (String)paymentInfos[i].getActualAmount().setScale(2).toString());
                } else {
                    JDomUtils.addChild((Element)InternalTrans, (String)"EquvAmt", (String)"");
                }
                JDomUtils.addChild((Element)InternalTrans, (String)"CustRef", (String)paymentInfos[i].getBankDetailSeqId());
                JDomUtils.addChild((Element)InternalTrans, (String)"ExContract", (String)paymentInfos[i].getExContract());
                JDomUtils.addChild((Element)InternalTrans, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate(paymentInfos[i].getBookingTime()));
                PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfos[i]);
                JDomUtils.addChild((Element)Record, (Element)InternalTrans);
                JDomUtils.addChild((Element)Requests, (Element)Record);
            }
            JDomUtils.addChild((Element)TransferREQ, (Element)Requests);
            JDomUtils.addChild((Element)Tx, (Element)TransferREQ);
            JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
            String requestMessage = JDomUtils.root2String((Element)BOCHKE2B, (String)RequestContextUtils.getCharset());
            log.info("\u3010\u53c3\u8207\u884c\u8f49\u8cec\u3011\u8bf7\u6c42\u62a5\u6587\uff1a" + requestMessage);
            String string = requestMessage;
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (EBServiceException e) {
                log.info(e.getLocalizedMessage());
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
            if ("F".equals(bankRsp.getResponseCode()) || "R".equals(bankRsp.getResponseCode())) {
                InternalTransPayImpl.trySetErrMsg(root, paymentInfos);
                return new EBBankPayResponse(Arrays.asList(paymentInfos));
            }
            if (!"S".equals(bankRsp.getResponseCode())) {
                String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
                String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"InternalTransPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
                return new EBBankPayResponse(Arrays.asList(paymentInfos));
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"InternalTransPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u7b14\u4ea4\u6613\u72b6\u6001\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u64cd\u4f5c\u3002", (String)"InternalTransPayImpl_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            Element Requests = root.getChild("Tx").getChild("TransferRLY").getChild("Requests");
            Element DebitAcctNo = root.getChild("Tx").getChild("TransferRLY").getChild("DebitAcctNo");
            List requestList = Requests.getChildren();
            block2: for (int i = 0; i < requestList.size(); ++i) {
                Element record = (Element)requestList.get(i);
                Element InternalTrans = record.getChild("InternalTrans");
                if (null == InternalTrans) continue;
                String CustRef = InternalTrans.getChildTextTrim("CustRef");
                for (int j = 0; j < paymentInfos.length; ++j) {
                    String RecordErrorDesc;
                    String RecordErrorCode;
                    String RecordStatus;
                    String actualAmountStr;
                    if (!CustRef.equals(paymentInfos[j].getBankDetailSeqId())) continue;
                    String amountStr = JDomUtils.getChildText((Element)InternalTrans, (String)"DebitAmt");
                    if (!StringUtils.isEmpty((String)amountStr)) {
                        paymentInfos[j].setAmount(new BigDecimal(amountStr));
                    }
                    if (!StringUtils.isEmpty((String)(actualAmountStr = JDomUtils.getChildText((Element)InternalTrans, (String)"EquvAmt")))) {
                        paymentInfos[j].setActualAmount(new BigDecimal(actualAmountStr));
                    }
                    if ("S".equals(RecordStatus = InternalTrans.getChildTextTrim("RecordStatus"))) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"InternalTransPayImpl_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)"", (String)"");
                        continue block2;
                    }
                    if ("F".equals(RecordStatus)) {
                        RecordErrorCode = InternalTrans.getChildTextTrim("RecordErrorCode");
                        RecordErrorDesc = InternalTrans.getChildTextTrim("RecordErrorDesc");
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"InternalTransPayImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordErrorCode, (String)RecordErrorDesc);
                        continue block2;
                    }
                    RecordErrorCode = InternalTrans.getChildTextTrim("RecordErrorCode");
                    RecordErrorDesc = InternalTrans.getChildTextTrim("RecordErrorDesc");
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"InternalTransPayImpl_4", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordErrorCode, (String)RecordErrorDesc);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"InternalTransPayImpl_4", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u62a5\u6587\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"InternalTransPayImpl_5", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)e.getMessage());
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public static void trySetErrMsg(Element root, PaymentInfo[] paymentInfos) {
        String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
        String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"InternalTransPayImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
        Element Requests = root.getChild("Tx").getChild("TransferRLY").getChild("Requests");
        List requestList = Requests.getChildren();
        int min = requestList.size() <= paymentInfos.length ? requestList.size() : paymentInfos.length;
        for (int i = 0; i < min; ++i) {
            Element record = (Element)requestList.get(i);
            Element InternalTrans = record.getChild("InternalTrans");
            if (null == InternalTrans) continue;
            String RecordStatus = InternalTrans.getChildTextTrim("RecordStatus");
            String RecordErrorDesc = InternalTrans.getChildTextTrim("RecordErrorDesc");
            RecordErrorDesc = StringUtils.isEmpty((String)RecordErrorDesc) ? ErrorDesc : RecordErrorDesc;
            paymentInfos[i].setBankStatus(RecordStatus);
            paymentInfos[i].setBankMsg(RecordStatus + "-" + RecordErrorDesc);
        }
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "TransferREQ - InternalTrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6.2.8 \u3010\u53c3\u8207\u884c\u8f49\u8cec\u3011(TransferREQ - InternalTrans)", (String)"InternalTransPayImpl_6", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BizName.QueryPay.PAY_FOR_SALARY.name().equalsIgnoreCase(paymentInfo.getSubBizType()) || BizName.OVERSEAPAY.name().equalsIgnoreCase(paymentInfo.getSubBizType()) ? BOCHK_DC_Constants.getINTERNAL_TRANS().equals(paymentInfo.getUseCN()) : paymentInfo.is2SameBank();
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

