/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.utils;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class ErrorCodeUtil {
    private static final String PAY_ERROR_CODE_FILENAME = "classpath:excel/payErrorCode.xls";
    private static final String FILENAME = "classpath:excel/errorCode.xls";
    private HSSFWorkbook workbook;
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ErrorCodeUtil.class);
    private static Map<String, String> errorCodeMap;
    private static Map<String, String> payErrorCodeMap;
    private static ErrorCodeUtil errorCodeUtils;

    private ErrorCodeUtil() {
        this.init();
    }

    public static ErrorCodeUtil getInstance() {
        return errorCodeUtils;
    }

    public String getErrorDesc(String code) {
        if (StringUtils.isEmpty((String)errorCodeMap.get(code))) {
            return code;
        }
        return errorCodeMap.get(code);
    }

    public String getPayErrorDesc(String code) {
        if (StringUtils.isEmpty((String)payErrorCodeMap.get(code))) {
            return code;
        }
        return payErrorCodeMap.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        errorCodeMap = new ConcurrentHashMap<String, String>();
        payErrorCodeMap = new ConcurrentHashMap<String, String>();
        InputStream is = null;
        try {
            is = Resources.getResource((String)FILENAME).openStream();
            this.workbook = new HSSFWorkbook(is);
            this.read2Map(this.workbook, errorCodeMap);
        }
        catch (Exception e1) {
            logger.error("\u8bfb\u53d6\u9519\u8bef\u7801\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        finally {
            if (null != is) {
                try {
                    if (null != this.workbook) {
                        this.workbook.close();
                    }
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        try {
            is = Resources.getResource((String)PAY_ERROR_CODE_FILENAME).openStream();
            this.workbook = new HSSFWorkbook(is);
            this.read2Map(this.workbook, payErrorCodeMap);
        }
        catch (Exception e1) {
            logger.error("\u8bfb\u53d6\u9519\u8bef\u7801\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        finally {
            if (null != is) {
                try {
                    if (null != this.workbook) {
                        this.workbook.close();
                    }
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void read2Map(HSSFWorkbook book, Map<String, String> map) {
        HSSFSheet sheet = book.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        for (int i = 1; i <= lastRowNum; ++i) {
            HSSFCell cell2;
            CellType cellType2;
            HSSFRow row = sheet.getRow(i);
            String code = "";
            String desc = "";
            HSSFCell cell1 = row.getCell(0);
            CellType cellType = cell1.getCellType();
            if (cellType.equals((Object)CellType.STRING)) {
                code = cell1.getStringCellValue();
            }
            if (cellType.equals((Object)CellType.NUMERIC)) {
                code = Math.round(cell1.getNumericCellValue()) + "";
            }
            if ((cellType2 = (cell2 = row.getCell(1)).getCellType()).equals((Object)CellType.STRING)) {
                desc = cell2.getStringCellValue();
            }
            if (cellType2.equals((Object)CellType.NUMERIC)) {
                desc = Math.round(cell2.getNumericCellValue()) + "";
            }
            map.put(code, desc);
        }
    }

    static {
        errorCodeUtils = new ErrorCodeUtil();
    }
}

