/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdnxs.dc.services.payment.same;

import java.util.List;
import kd.ebg.aqap.banks.gdnxs.dc.services.payment.same.QrySamePayImpl;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Packer;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SamePaymentImpl
extends AbstractPayImpl
implements IPay {
    private final String TRANCODE = "B2EBankInnerTransfer";

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySamePayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead("B2EBankInnerTransfer", paymentInfo.getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
            JDomUtils.addChild((Element)Map2, (String)"ListNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
            JDomUtils.addChild((Element)Map2, (String)"PayerAcNo", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)Map2, (String)"Amount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)Map2, (String)"Remark", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
        }
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = bank_root.getChild("Head");
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = GDNXS_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if ("000000".equals(bankStatus)) {
            Element lists = body.getChild("List");
            List list = lists.getChildren("Map");
            for (Element map : list) {
                String ReturnCode = map.getChildText("ReturnCode");
                String returnMsg = map.getChildText("ReturnMsg");
                String ListNo = map.getChildText("ListNo");
                PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)ListNo);
                if ("000000".equals(ReturnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)returnMsg, (String)bankStatus, (String)headRsp.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)returnMsg, (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)headRsp.getResponseMessage(), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/B2EBankInnerTransfer.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }
}

