/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbc.dc.services.payment.company;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ocbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ocbc.dc.services.OCBC_DC_Packer;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

final class PayPacker {
    PayPacker() {
    }

    public static String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4eba\u6c11\u5e01\u8f6c\u8d26\u652f\u4ed8 [srv012_CNY_transfr]\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
        }
        PaymentInfo info = paymentInfos[0];
        Element root = OCBC_DC_Packer.createRoot(info.getBankDetailSeqId());
        Element opReq = root.getChild("opReq");
        Element reqParam = opReq.getChild("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"FKZH", (String)info.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"FKHM", (String)info.getAccName());
        JDomUtils.addChild((Element)reqParam, (String)"SKZH", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"SKHM", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"SKHH", (String)info.getIncomeCnaps());
        JDomUtils.addChild((Element)reqParam, (String)"SKHN", (String)info.getIncomeBankName());
        BigDecimal amount = info.getAmount().multiply(new BigDecimal("100.00")).setScale(0);
        JDomUtils.addChild((Element)reqParam, (String)"JYJE", (String)amount.toString());
        JDomUtils.addChild((Element)reqParam, (String)"GSBS", (String)(info.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)reqParam, (String)"PTJJ", (String)(info.is2Urgent() ? "u" : "o"));
        String customId = EBContext.getContext().getCustomID();
        String code = info.is2Individual() ? UseKeyWordService.getUseByKey((String)customId, (String)info.getExplanation(), (String)"srv012_individual", (String)"201", (String)"OCBC_DC") : UseKeyWordService.getUseByKey((String)customId, (String)info.getExplanation(), (String)"srv012_company", (String)"102", (String)"OCBC_DC");
        JDomUtils.addChild((Element)reqParam, (String)"YTDM", (String)code);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            JDomUtils.addChild((Element)reqParam, (String)"BEIZ", (String)BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation()));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"BEIZ", (String)info.getExplanation());
        }
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return OCBC_DC_Packer.createMessageWithHead(requestMessage);
    }
}

