/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        String balanceStr = JDomUtils.getChildText((Element)txInfo, (String)"BALANCE");
        String aviBalanceStr = JDomUtils.getChildText((Element)txInfo, (String)"BALANCE1");
        BalanceInfo balance = new BalanceInfo();
        balance.setBalanceDateTime(LocalDateTime.now());
        balance.setBankAcnt(rqst.getHeader().getAcnt());
        balance.setBankCurrency(rqst.getBankCurrency());
        BalanceUtil.setCurrentBalance((BalanceInfo)balance, (String)balanceStr);
        BalanceUtil.setAvailableBalance((BalanceInfo)balance, (String)aviBalanceStr);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }
}

