/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.detail.CurrencyManager;
import kd.ebg.aqap.banks.icbc.cmp.service.detail.ICBC_CMP_DetailUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SeniorDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SeniorDetailImpl.class);

    public boolean isTodayDetailReverse() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        EBBankDetailResponse response = new EBBankDetailResponse();
        EBBankDetailResponse tempResponse = this.doBiz(request);
        response.setDetails(tempResponse.getDetails());
        while (!tempResponse.isLastPage() && tempResponse.getDetails().size() > 0) {
            request.setPageNum(tempResponse.getPageNum());
            request.setNextPageTag(tempResponse.getNextPageTag());
            tempResponse = this.doBiz(request);
            response.getDetails().addAll(tempResponse.getDetails());
        }
        return response;
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.hisDetail(request);
    }

    public boolean match(BankDetailRequest request) {
        return super.match(request);
    }

    public String pack(BankDetailRequest request) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QHISD");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)in, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)in, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)in, (String)"MinAmt", (String)"1");
        JDomUtils.addChild((Element)in, (String)"MaxAmt", (String)"999999999999999");
        JDomUtils.addChild((Element)in, (String)"BankType", (String)"");
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)request.getNextPageTag());
        JDomUtils.addChild((Element)in, (String)"CurrType", (String)request.getHeader().getBankCurrency());
        JDomUtils.addChild((Element)in, (String)"DueBillNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"AcctSeq", (String)"");
        JDomUtils.addChild((Element)in, (String)"ComplementFlag", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String msg = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(msg, "QHISD", "0.0.1.0");
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        String rspStrDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = request.getHeader().getAcnt();
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStrDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element out = eb.getChild("out");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if ("B0116".equalsIgnoreCase(headRsp.getResponseCode()) || "310211".equalsIgnoreCase(headRsp.getResponseCode())) {
                return new EBBankDetailResponse(detailList);
            }
            String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"SeniorDetailImpl_7", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StrUtil.join((String)" ", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage()));
            throw EBExceiptionUtil.serviceException((String)errMsg);
        }
        String accNo = out.getChildTextTrim("AccNo");
        if (!accNo.equalsIgnoreCase(acnt.getAccNo())) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5de5\u884c\u9519\u8bef\u7684\u54cd\u5e94:\u8bf7\u6c42\u7684\u8d26\u53f7\u662f%1$s;\u8fd4\u56de\u7684\u8d26\u53f7\u5374\u662f%2$s\u3002", (String)"SeniorDetailImpl_8", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), acnt.getAccNo(), accNo);
            throw EBExceiptionUtil.serviceException((String)errMsg);
        }
        String outCurr = out.getChildTextTrim("CurrType");
        if (StringUtils.isEmpty((String)outCurr)) {
            outCurr = request.getBankCurrency();
        }
        List list = out.getChildren("rd");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            LocalDate date;
            DetailInfo detail = new DetailInfo();
            Element rd = (Element)list.get(i);
            String currency = rd.getChildTextTrim("CurrType");
            String TrxCurr = rd.getChildTextTrim("TrxCurr");
            if (StringUtils.isEmpty((String)currency) && !StringUtils.isEmpty((String)TrxCurr)) {
                currency = TrxCurr;
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = outCurr;
            }
            logger.info("\u5e01\u79cd1{}", (Object)currency);
            currency = CurrencyManager.instance().convert2BankStandard(currency);
            logger.info("\u5e01\u79cd2{}", (Object)currency);
            detail.setCurrency(currency);
            String drcrf = rd.getChildTextTrim("Drcrf");
            String debitAmountStr = JDomUtils.getChildText((Element)rd, (String)"DebitAmount");
            String creditAmountStr = JDomUtils.getChildText((Element)rd, (String)"CreditAmount");
            String balanceStr = JDomUtils.getChildText((Element)rd, (String)"Balance");
            if (StrUtil.isEmpty((String)debitAmountStr) && StrUtil.isEmpty((String)creditAmountStr)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5de5\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\uff0cdebitAmount=%1$s\uff0ccreditAmount=%2$s\u3002", (String)"SeniorDetailImpl_9", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), debitAmountStr, creditAmountStr));
            }
            BigDecimal debitAmount = ParserUtils.convertCentStr2Yuan((String)debitAmountStr);
            BigDecimal creditAmount = ParserUtils.convertCentStr2Yuan((String)creditAmountStr);
            BigDecimal balance = ParserUtils.convertCentStr2Yuan((String)balanceStr);
            if ("1".equalsIgnoreCase(drcrf)) {
                detail.setDebitAmount(debitAmount);
                if (null != creditAmount) {
                    detail.setCreditAmount(creditAmount);
                } else {
                    detail.setCreditAmount(ParserUtils.ZERO);
                }
            } else if ("2".equalsIgnoreCase(drcrf)) {
                detail.setCreditAmount(creditAmount);
                if (null != debitAmount) {
                    detail.setDebitAmount(debitAmount);
                } else {
                    detail.setDebitAmount(ParserUtils.ZERO);
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5de5\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7Drcrf=%s\u3002", (String)"SeniorDetailImpl_10", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), drcrf));
            }
            if (null != balance) {
                detail.setBalance(balance);
            }
            String oppAccNo = rd.getChildTextTrim("RecipAccNo");
            String oppAccName = rd.getChildTextTrim("RecipName");
            String oppBankName = rd.getChildTextTrim("RecipBkName1");
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            if (StrUtil.isEmpty((String)oppBankName)) {
                oppBankName = rd.getChildTextTrim("RecipBkName");
            }
            detail.setOppBankName(oppBankName);
            String summary = rd.getChildTextTrim("Summary");
            String postScript = rd.getChildTextTrim("PostScript");
            String ref = rd.getChildTextTrim("Ref");
            String busCode = rd.getChildTextTrim("BusCode");
            if ("1".equalsIgnoreCase(drcrf)) {
                String batchNo;
                if (ref != null && ref.startsWith("KD_")) {
                    batchNo = ref.substring("KD_".length());
                    detail.setPayBankDetailSeqID(batchNo);
                } else if (postScript != null && postScript.indexOf("KD_") != -1) {
                    batchNo = postScript.substring(0, postScript.indexOf("KD_"));
                    postScript = postScript.substring(batchNo.length() + "KD_".length());
                    detail.setPayBankDetailSeqID(batchNo);
                } else if (busCode != null && busCode.indexOf("KD_") != -1) {
                    batchNo = busCode.substring("KD_".length());
                    detail.setPayBankDetailSeqID(batchNo);
                }
                detail.setKdFlag("KD");
            }
            if (StrUtil.isEmpty((String)postScript)) {
                detail.setExplanation(summary);
            } else {
                detail.setExplanation(postScript);
            }
            String masterCardNo = rd.getChildText("MDCARDNO");
            if (!StrUtil.isEmpty((String)masterCardNo)) {
                StringBuilder sb = new StringBuilder();
                sb.append(detail.getExplanation()).append(ResManager.loadKDString((String)"-\u7ba1\u5bb6\u5361\u5361\u53f7\uff1a", (String)"SeniorDetailImpl_5", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0])).append(masterCardNo);
                detail.setExplanation(sb.toString());
            }
            String useCn = rd.getChildTextTrim("UseCN");
            detail.setUseCN(useCn);
            String timeStamp = rd.getChildTextTrim("Time");
            String dateStr = rd.getChildTextTrim("Date");
            if (timeStamp.length() == 8) {
                timeStamp = dateStr.substring(0, 4) + "-" + dateStr.substring(4, 6) + "-" + dateStr.substring(6, 8) + "-" + timeStamp;
            } else if (timeStamp.length() > 19) {
                timeStamp = timeStamp.substring(0, 19);
            }
            try {
                date = LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
                detail.setTransDate(date);
                LocalDateTime time = LocalDateTime.parse(timeStamp, DateTimeFormatter.ofPattern("yyyy-MM-dd-HH.mm.ss"));
                String _timeStr = time.toLocalTime().format(DateTimeFormatter.ofPattern("HHmmss"));
                LocalDateTime transTime = null;
                transTime = !StrUtil.isEmpty((String)summary) && summary.indexOf(PropertiesConstants.getValue((String)"AGREE_SAVE")) != -1 && !date.isEqual(time.toLocalDate()) ? LocalDateTime.parse(dateStr + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : (date.isBefore(time.toLocalDate()) ? LocalDateTime.parse(dateStr + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(dateStr + _timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                detail.setTransTime(transTime);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            String upDtranf = rd.getChildTextTrim("UpDtranf");
            if ("3".equalsIgnoreCase(upDtranf) && LocalDate.now().isEqual(date)) {
                detail.setDebitAmount(creditAmount == null ? ParserUtils.ZERO : creditAmount);
                detail.setCreditAmount(debitAmount == null ? ParserUtils.ZERO : debitAmount);
            }
            String busTypNo = rd.getChildTextTrim("BusTypNo");
            String tInfoNew = rd.getChildTextTrim("TInfoNew");
            DetailSysFiled.set((DetailInfo)detail, (String)"TInfoNew", (String)tInfoNew);
            String user = "";
            if (!StrUtil.isEmpty((String)tInfoNew)) {
                user = tInfoNew.split("\\|")[2];
            }
            String receiptInfo = rd.getChildTextTrim("ReceiptInfo");
            String transType = ICBC_CMP_DetailUtils.getTransType(busTypNo, user, receiptInfo);
            if (PropertiesConstants.getValue((String)"CASH_UP").equalsIgnoreCase(summary) || PropertiesConstants.getValue((String)"MEMBER_COLLECTION").equalsIgnoreCase(summary)) {
                detail.setTransType("autotransup");
            } else if (PropertiesConstants.getValue((String)"MEMBER_PAY").equalsIgnoreCase(summary)) {
                detail.setTransType("autotransdown");
            } else {
                detail.setTransType(transType);
            }
            String VouhNo = rd.getChildText("VouhNo");
            detail.setVouhNo(VouhNo);
            String detailNo = JDomUtils.getChildText((Element)rd, (String)"OnlySequence");
            String timeStamp1 = rd.getChildTextTrim("Time");
            if ("timeStamp".equalsIgnoreCase(BankBusinessConfig.chooseBizRefNo())) {
                if (StrUtil.isEmpty((String)timeStamp1)) {
                    timeStamp1 = "";
                }
                detail.setBizRefNo(timeStamp1);
            } else if ("onlySequence".equalsIgnoreCase(BankBusinessConfig.chooseBizRefNo())) {
                if (StringUtils.isEmpty((String)detailNo)) {
                    detailNo = "";
                }
                detail.setBizRefNo(detailNo);
            } else if ("orderNo".equalsIgnoreCase(BankBusinessConfig.chooseBizRefNo())) {
                String bizRefNo = ICBC_CMP_DetailUtils.getBizRefNo(receiptInfo);
                if (StringUtils.isEmpty((String)bizRefNo)) {
                    if (StringUtils.isEmpty((String)timeStamp1)) {
                        timeStamp1 = "";
                    }
                    bizRefNo = timeStamp1;
                }
                detail.setBizRefNo(bizRefNo);
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(rd);
            detail.setJsonMap(jsonStr);
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, dateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailNo);
            detailList.add(detail);
        }
        String nextTag = out.getChildTextTrim("NextTag");
        EBBankDetailResponse response = new EBBankDetailResponse(detailList);
        response.setLastPage(StringUtils.isEmpty((String)nextTag));
        response.setPageNum(request.getPageNum() + 1);
        response.setNextPageTag(nextTag);
        return response;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "QHISD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2015\u5e7412\u67084\u65e511:01:44 \u542f\u7528\u65b0\u7248\u7684\u9ad8\u7ea7\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", (String)"SeniorDetailImpl_6", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }
}

