/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.banks.shrcb.dc.utils.Packer;
import kd.ebg.aqap.banks.shrcb.dc.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        String sessionId = new LoginImpl().getSessionID();
        Element root = Packer.createCommonHead("0100", sessionId);
        ArrayList bodyList = new ArrayList();
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("AcctNo", request.getAcnt().getAccNo());
        param.put("StartDate", request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        param.put("EndDate", request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        param.put("CurrentCount", "1");
        bodyList.add(param);
        Packer.addBody(root, bodyList);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String accountNo = body.getChildTextTrim("accountNo");
        String total_count = body.getChildTextTrim("total_count");
        int count = Integer.parseInt(total_count);
        Element tran_record = body.getChild("tran_record_list");
        List recordList = tran_record.getChildren("record");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < recordList.size() && i < count; ++i) {
            Element record = (Element)recordList.get(i);
            BalanceInfo balance = new BalanceInfo();
            this.setBankAcnt(balance, request.getBankAcntList(), accountNo);
            balance.setBankCurrency(request.getBankCurrency());
            this.setCurrentBalance(balance, record.getChildTextTrim("Balance"));
            this.setBalanceDateTime(balance, record.getChildTextTrim("Date") + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            balanceInfos.add(balance);
        }
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances(balanceInfos);
        return rsp;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "0100";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return LocalDate.of(2022, 1, 1);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
        factory.setHttpHeader("Content-Encoding", "utf-8");
    }
}

