/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.services.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.detail.SingleDetailInfo;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.banks.shrcb.dc.utils.Packer;
import kd.ebg.aqap.banks.shrcb.dc.utils.Parser;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SingleDetialImpl
extends AbstractImpl {
    private String packSendMsg(SingleDetailInfo singleDetail) {
        String sessionId = new LoginImpl().getSessionID();
        Element root = Packer.createCommonHead("0004", sessionId);
        ArrayList bodyList = new ArrayList(1);
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>(16);
        param.put("transDate", singleDetail.getTransDate());
        param.put("tranAmount", singleDetail.getTranAmount());
        param.put("remark", singleDetail.getRemark());
        param.put("coreSerialNum", singleDetail.getCoreSerialNum());
        param.put("seqNo", singleDetail.getSeqNo());
        param.put("channelFlag", singleDetail.getChannelFlag());
        param.put("summaryCode", singleDetail.getSummaryCode());
        param.put("accountNo", singleDetail.getAccountNo());
        param.put("uuid", singleDetail.getUuid());
        param.put("transNo", singleDetail.getTransNo());
        param.put("dataFlag", singleDetail.getDataFlag());
        bodyList.add(param);
        Packer.addBody(root, bodyList);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private void parseRecvMsg(SingleDetailInfo singleDetail, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            return;
        }
        Element body = root.getChild("body");
        String accountNo = body.getChildTextTrim("account_no");
        String accountName = body.getChildTextTrim("account_name");
        String payeeAccountName = body.getChildTextTrim("payee_account_name");
        String payeeAccountNo = body.getChildTextTrim("payee_account_no");
        singleDetail.setAccountNo(accountNo);
        singleDetail.setAccountName(accountName);
        singleDetail.setPayeeAccountNo(payeeAccountNo);
        singleDetail.setPayeeAccountName(payeeAccountName);
    }

    private boolean needQueryOppAcntInfo(SingleDetailInfo detail) {
        return StringUtils.isEmpty((String)detail.getPayeeAccountNo()) || StringUtils.isEmpty((String)detail.getPayeeAccountName());
    }

    public void completeOppAcntInfo(SingleDetailInfo singleDetail, DetailInfo detail) {
        if (!this.needQueryOppAcntInfo(singleDetail)) {
            return;
        }
        try {
            this.querySingleDetailInfo(singleDetail);
            if ("0".equalsIgnoreCase(singleDetail.getCdFlag())) {
                detail.setOppAccNo(singleDetail.getPayeeAccountNo());
                detail.setOppAccName(singleDetail.getPayeeAccountName());
            } else {
                detail.setOppAccNo(singleDetail.getAccountNo());
                detail.setOppAccName(singleDetail.getAccountName());
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u7b14\u660e\u7ec6\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,\u53c2\u8003\u539f\u56e0:", (String)"SingleDetialImpl_0", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void querySingleDetailInfo(SingleDetailInfo detail) {
        try {
            String rqstStr = this.packSendMsg(detail);
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rqstStr);
                this.closeOutputStreamQuietly(os);
                try (InputStream is = this.getInputStream(conn);){
                    String rspStr = this.recv(is);
                    this.closeInputStreamQuietly(is);
                    this.parseRecvMsg(detail, rspStr);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
        factory.setHttpHeader("Content-Encoding", "utf-8");
    }
}

