/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.payment.company;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo info) {
        return true;
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u67e5\u8be2\uff08\u5bf9\u516c\uff09\u652f\u4ed8\u72b6\u6001\u3002", (String)"CompanyPayQueryImpl_0", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u7684'\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001 (200205\u4ea4\u6613)'\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"CompanyPayQueryImpl_1", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ZSB_DC_Packer.buildHead("200205", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return ZSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("1_2100".equalsIgnoreCase(rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayQueryImpl_3", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        } else {
            Element body = root.getChild("body");
            String ret_code = body.getChildTextTrim("stat");
            String error_info = body.getChildTextTrim("error_info");
            if ("6".equalsIgnoreCase(ret_code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayQueryImpl_4", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
            } else if ("9".equalsIgnoreCase(ret_code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPayQueryImpl_5", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
            } else if ("8".equalsIgnoreCase(ret_code) || "D".equals(ret_code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5__%s\u3002", (String)"CompanyPayQueryImpl_8", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), ret_code), (String)ret_code, (String)error_info);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayQueryImpl_6", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }
}

