/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.detail;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.detail.CommonDetailParser;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    public String pack(BankDetailRequest request) {
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"ACCT_NO", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"BEGIN_DATE", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"END_DATE", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"ACC_TYPE", (String)"");
        int currentPage = Integer.parseInt(this.getCurrentPage()) + 1;
        JDomUtils.addChild((Element)body, (String)"CURRENT_PAGE", (String)(currentPage + ""));
        String requestStr = CommonUtil.getPackerData(Constants.HISTORY_DETAIL, body);
        return requestStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        this.setLastPage(true);
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        Element array = body.getChild("ARRAY");
        List list = array.getChildren("STRUCT");
        if (list.size() == 0) {
            return new EBBankDetailResponse(new ArrayList(16));
        }
        String totalRows = body.getChildText("TOTALROWS");
        this.handLastPage(totalRows, list);
        return CommonDetailParser.parseDetail(bankDetailRequest, list);
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.HISTORY_DETAIL;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6", (String)"HistoryDetailImpl_0", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public void handLastPage(String totalRows, List<Element> list) {
        if (list.size() < 20) {
            this.setLastPage(true);
            return;
        }
        if (StringUtils.isNotEmpty((String)totalRows)) {
            String currentPage = this.getCurrentPage();
            int count = (Integer.parseInt(currentPage) + 1) * 20;
            if (count < Integer.parseInt(totalRows)) {
                this.setLastPage(false);
                this.setCurrentPage(Integer.parseInt(currentPage) + 1);
                return;
            }
            this.setLastPage(true);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

