/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc.services.payment.giro;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.ocbcsg.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ocbcsg.dc.OcbcSgMetaDataImpl;
import kd.ebg.aqap.banks.ocbcsg.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang3.StringUtils;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        StringBuilder sb = new StringBuilder();
        String head = this.packHeader(paymentInfos);
        sb.append(head);
        sb.append(System.getProperty("line.separator"));
        String detail = this.packPayDetail(paymentInfos);
        sb.append(detail);
        return sb.toString();
    }

    private String packPayDetail(List<PaymentInfo> paymentInfos) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = paymentInfos.get(i);
            sb.append(StringUtils.rightPad((String)paymentInfo.getIncomeSwiftCode(), (int)11, (String)" "));
            sb.append(StringUtils.rightPad((String)paymentInfo.getIncomeAccNo(), (int)34, (String)" "));
            sb.append(StringUtils.rightPad((String)paymentInfo.getIncomeAccName(), (int)140, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
            BigDecimal amount = paymentInfo.getAmount().multiply(new BigDecimal(100).stripTrailingZeros());
            sb.append(StringUtils.leftPad((String)amount.toPlainString(), (int)17, (String)"0"));
            sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
            sb.append("OTHR");
            sb.append(StringUtils.rightPad((String)paymentInfo.getBankDetailSeqID(), (int)35, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)140, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)140, (String)" "));
            String emails = paymentInfo.getEmails();
            if (StringUtils.isNotBlank((CharSequence)emails)) {
                sb.append("E");
                sb.append(StringUtils.rightPad((String)emails, (int)255, (String)" "));
            } else {
                sb.append(" ");
                sb.append(StringUtils.rightPad((String)"", (int)255, (String)" "));
            }
            sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)140, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)33, (String)" "));
            sb.append(System.getProperty("line.separator"));
            sb.append("INV");
            sb.append(StringUtils.rightPad((String)"", (int)97, (String)" "));
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private String packHeader(List<PaymentInfo> paymentInfos) {
        String bookTime;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("10");
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        sb.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        sb.append("OCBCSGSGXXX");
        sb.append(StringUtils.rightPad((String)paymentInfo.getAccNo(), (int)34, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)20, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)120, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        if (paymentInfo.getUseCN().equalsIgnoreCase("FAST")) {
            sb.append("FAST");
            RequestContextUtils.setRunningParam((String)"isFAST", (String)"true");
        } else {
            RequestContextUtils.setRunningParam((String)"isFAST", (String)"false");
            sb.append("GIRO");
        }
        sb.append(StringUtils.rightPad((String)paymentInfo.getBankDetailSeqID(), (int)16, (String)" "));
        if (paymentInfo.getBookingTime() != null) {
            bookTime = paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("ddMMyyyy"));
            PaymentUtil.setBookPayFlag(paymentInfos);
        } else {
            bookTime = LocalDate.now().format(DateTimeFormatter.ofPattern("ddMMyyyy"));
        }
        sb.append(bookTime);
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)1, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)762, (String)" "));
        return sb.toString();
    }

    protected String getPayFileName(BankPayRequest bankPayRequest) {
        StringBuilder sb = new StringBuilder();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String prefix = RequestContextUtils.getBankParameterValue((String)OcbcSgMetaDataImpl.pay_file_name);
        String payFilePrefix = BankBusinessConfig.getPayFilePrefix(paymentInfo.getAccNo());
        if (StringUtils.isNotBlank((CharSequence)payFilePrefix)) {
            prefix = payFilePrefix;
        }
        String isFAST = RequestContextUtils.getRunningParam((String)"isFAST");
        String nnnn = "GPAY";
        if (Boolean.parseBoolean(isFAST)) {
            nnnn = "FPAY";
        }
        sb.append(prefix).append("_").append(nnnn).append("_").append("GIROFAST").append("_").append(paymentInfo.getBankBatchSeqID()).append("_").append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("_").append(LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"))).append(".txt.pgp");
        return sb.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GIRO";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getUseCN().equalsIgnoreCase("FAST") || paymentInfo.getUseCN().equalsIgnoreCase("GIRO");
    }
}

