/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc.services.payment.meps;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.ocbcsg.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ocbcsg.dc.OcbcSgMetaDataImpl;
import kd.ebg.aqap.banks.ocbcsg.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import org.apache.commons.lang3.StringUtils;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    protected String getPayFileName(BankPayRequest bankPayRequest) {
        StringBuilder sb = new StringBuilder();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String prefix = RequestContextUtils.getBankParameterValue((String)OcbcSgMetaDataImpl.pay_file_name);
        String payFilePrefix = BankBusinessConfig.getPayFilePrefix(paymentInfo.getAccNo());
        if (StringUtils.isNotBlank((CharSequence)payFilePrefix)) {
            prefix = payFilePrefix;
        }
        sb.append(prefix).append("_").append("MEPS").append("_").append("ALLSWIFT").append("_").append(paymentInfo.getBankBatchSeqID()).append("_").append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("_").append(LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"))).append(".txt.pgp");
        return sb.toString();
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String bookTime;
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        String productid = StringUtils.rightPad((String)"MEPS", (int)4, (String)" ");
        sb.append(productid);
        String bankDetailSeqID = StringUtils.rightPad((String)paymentInfo.getBankDetailSeqID(), (int)16, (String)" ");
        sb.append(bankDetailSeqID);
        String accNo = StringUtils.rightPad((String)paymentInfo.getAccNo(), (int)14, (String)" ");
        sb.append(accNo);
        String currency = StringUtils.rightPad((String)paymentInfo.getCurrency(), (int)3, (String)" ");
        sb.append(currency);
        if (paymentInfo.getBookingTime() != null) {
            bookTime = paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            PaymentUtil.setBookPayFlag((List)bankPayRequest.getPaymentInfos());
        } else {
            bookTime = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        sb.append(bookTime);
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        String amount = StringUtils.rightPad((String)paymentInfo.getAmount().toString(), (int)15, (String)" ");
        sb.append(amount);
        sb.append(" ");
        sb.append(" ");
        String Charges = "BEN";
        if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            Charges = "OUR";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            Charges = "SHA";
        }
        sb.append(Charges);
        String incomeAccNo = StringUtils.rightPad((String)paymentInfo.getIncomeAccNo(), (int)35, (String)" ");
        sb.append(incomeAccNo);
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        String incomeAccName = StringUtils.rightPad((String)paymentInfo.getIncomeAccName(), (int)35, (String)" ");
        sb.append(incomeAccName);
        String incomeAddress = paymentInfo.getIncomeAddress();
        String address1 = "";
        String address2 = "";
        if (StringUtils.isNotBlank((CharSequence)incomeAddress) && incomeAddress.length() > 35) {
            address1 = incomeAddress.substring(0, 35);
            address2 = incomeAddress.substring(35);
        } else {
            address1 = incomeAddress;
        }
        sb.append(StringUtils.rightPad((String)address1, (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)address2, (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        String bankAddress1 = "";
        String bankAddress2 = "";
        String incomeBankAddress = paymentInfo.getIncomeBankAddress();
        if (StringUtils.isNotBlank((CharSequence)incomeBankAddress) && incomeBankAddress.length() > 35) {
            bankAddress1 = incomeAddress.substring(0, 35);
            bankAddress2 = incomeAddress.substring(35);
        } else {
            bankAddress1 = incomeBankAddress;
        }
        sb.append(StringUtils.rightPad((String)bankAddress1, (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)bankAddress2, (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        if (StringUtils.isNotBlank((CharSequence)paymentInfo.getIncomeSwiftCode()) && paymentInfo.getIncomeSwiftCode().contains("OCBC")) {
            sb.append("7339");
            sb.append("501");
        } else if (StringUtils.isNotBlank((CharSequence)paymentInfo.getIncomeSwiftCode()) && paymentInfo.getIncomeSwiftCode().contains("HSBC")) {
            sb.append("7232");
            sb.append("141");
        } else if (StringUtils.isNotBlank((CharSequence)paymentInfo.getIncomeSwiftCode()) && paymentInfo.getIncomeSwiftCode().contains("SBI")) {
            sb.append("7791");
            sb.append("227");
        } else {
            sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
            sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        }
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)2, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)2, (String)" "));
        sb.append(StringUtils.rightPad((String)paymentInfo.getExplanation(), (int)140, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        String emails = paymentInfo.getEmails();
        if (StringUtils.isNotBlank((CharSequence)emails)) {
            sb.append("E");
            sb.append(StringUtils.rightPad((String)emails, (int)50, (String)" "));
        } else {
            sb.append(" ");
            sb.append(StringUtils.rightPad((String)"", (int)50, (String)" "));
        }
        sb.append(StringUtils.rightPad((String)"", (int)24, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)256, (String)" "));
        sb.append(" ");
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)paymentInfo.getIncomeSwiftCode(), (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)16, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)16, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        return sb.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getUseCN().equalsIgnoreCase("MEPS");
    }
}

