/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.payment.CommonQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CommonQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packRequest(bankPayRequest);
    }

    private String packRequest(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element body = JDomUtils.createRoot((String)"body");
        PaymentInfo paymentInfo = paymentInfos[0];
        String gtrType = UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? "1" : "2";
        JDomUtils.addChild((Element)body, (String)"payAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcvAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"gtrType", (String)gtrType);
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfo.getExplanation());
        return PackHelper.getPackMessage("01603040204B3001", paymentInfo.getBankBatchSeqId(), body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        PaymentInfo[] paymentInfoAsArray = bankPayRequest.getPaymentInfoAsArray();
        ParserHelper.defaultPayParser(paymentInfoAsArray, res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603040204B3001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212\u4e0b\u62e8", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

