/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Element;

public class HSB_DC_Parser {
    private static final String[] ACCEPTCODES = new String[]{"0_0000", "1_0000", "8_0000", "9_000000"};
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HSB_DC_Parser.class);

    public static BankResponse parseResponeCode(Element root) throws EBServiceException {
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info + "_" + ext_info);
        return rsp;
    }

    public static PaymentInfo findPaymentInfo(List<PaymentInfo> paymentInfos, String batchNo, String recAcc, String recAccName, String amount) throws EBServiceException {
        String packageId = paymentInfos.get(0).getPackageId();
        if (!packageId.equalsIgnoreCase(batchNo)) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7{}\u548c\u5f53\u524d\u6279\u6b21\u53f7{}\u4e0d\u4e00\u81f4", new Object[]{batchNo, packageId});
            return null;
        }
        for (PaymentInfo pay : paymentInfos) {
            if (!pay.getIncomeAccNo().equalsIgnoreCase(recAcc)) {
                logger.info("\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u53f7{}\u548c\u5f53\u524d\u8d26\u6237\u53f7{}\u4e0d\u4e00\u81f4", new Object[]{recAcc, pay.getIncomeAccNo()});
                return null;
            }
            if (!pay.getIncomeAccName().equalsIgnoreCase(recAccName)) {
                logger.info("\u94f6\u884c\u8fd4\u56de\u6237\u540d{}\u548c\u5f53\u524d\u6237\u540d{}\u4e0d\u4e00\u81f4", new Object[]{recAccName, pay.getIncomeAccName()});
                return null;
            }
            BigDecimal payAmount = pay.getAmount();
            int i = payAmount.compareTo(new BigDecimal(amount));
            if (i == 0) {
                return pay;
            }
            logger.info("\u94f6\u884c\u91d1\u989d{}\u548c\u5f53\u524d\u8d26\u6237\u91d1\u989d{}\u4e0d\u4e00\u81f4", new Object[]{amount, pay.getAmount().toString()});
        }
        return null;
    }
}

