/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Packer;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = HSB_DC_Packer.buildHead("200108", RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String acno = body.getChildTextTrim("acno");
        String cur_code = body.getChildTextTrim("cur_code");
        String acname = body.getChildTextTrim("acname");
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        String freeze_bal = body.getChildTextTrim("freeze_bal");
        if (!request.getAcnt().getAccNo().equalsIgnoreCase(acno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,\u539f\u56e0:\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>();
        balances.add(balanceInfo);
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
        balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)use_balance, (Boolean)true));
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u4f59\u989d (200108\u4ea4\u6613)", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

