/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Parser;
import kd.ebg.aqap.banks.hsb.dc.service.proxy.DetailFileDownLoad;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public static List<DetailInfo> parseTodayDetail(BankDetailRequest request, String rspStr) throws EBServiceException {
        return DetailParser.parseNormalDetail(request, rspStr);
    }

    private static List<DetailInfo> parseNormalDetail(BankDetailRequest request, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(rspStr = rspStr.substring(rspStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0:%1$s,%2$s", (String)"DetailParser_6", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            return detailList;
        }
        String[] splits = new String[]{};
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            DetailFileDownLoad fileDownLoad = new DetailFileDownLoad();
            String detailContent = fileDownLoad.doBiz(file_name);
            splits = StringUtils.split((String)detailContent, (String)"|");
        } else if ("0".equalsIgnoreCase(file_flag)) {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\u3002\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684file_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u5bfc\u81f4\u94f6\u4f01\u4e91\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        logger.info("\u8fdb\u884c\u660e\u7ec6\u6587\u4ef6\u622a\u53d6");
        String msg = "";
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), "200110");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            msg = buffer.toString();
            logger.info("\u7b2c{}\u6761\u4ea4\u6613\u660e\u7ec6\u7684\u5185\u5bb9\uff1a{}", new Object[]{i, msg});
            String acno = splits[fieldNum * i + 1];
            String cur_code = splits[fieldNum * i + 2];
            String tr_acdt = splits[fieldNum * i + 3];
            String tr_time = splits[fieldNum * i + 4];
            String host_serial_no = splits[fieldNum * i + 5];
            String acname = splits[fieldNum * i + 7];
            String oppAcntNumber = splits[fieldNum * i + 8];
            String oppName = splits[fieldNum * i + 10];
            String oppBank = splits[fieldNum * i + 11];
            String crdr_flag = splits[fieldNum * i + 23];
            String amt = splits[fieldNum * i + 24];
            String balance = splits[fieldNum * i + 25];
            String summary = splits[fieldNum * i + 34];
            String postscript = splits[fieldNum * i + 35];
            String tr_timestamp = splits[fieldNum * i + 36];
            if (!request.getAcnt().getAccNo().equalsIgnoreCase(acno)) {
                logger.info("===\u8bf7\u6c42\u8d26\u53f7[" + request.getAcnt().getAccNo() + "]\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[" + acno + "]\u4e0d\u4e00\u81f4\uff0c\u88ab\u8fc7\u6ee4\u7684\u660e\u7ec6===");
                continue;
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setOppAccNo(oppAcntNumber);
            detail.setOppAccName(oppName);
            detail.setBankName(oppBank);
            detail.setCurrency(cur_code);
            if (!StringUtils.isEmpty((String)host_serial_no)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)host_serial_no);
            }
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    EBServiceException ex = EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailParser_2", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
                    logger.error("", (Throwable)ex);
                    throw ex;
                }
                detail.setTransTime(LocalDateTime.parse(tr_acdt + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                detail.setTransDate(LocalDateUtil.parserDate((String)tr_acdt, (String)"yyyyMMdd"));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%s", (String)"DetailParser_7", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if ("D".equalsIgnoreCase(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal(amt));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else if ("C".equalsIgnoreCase(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal("0.00"));
                detail.setCreditAmount(new BigDecimal(amt));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s,\u671f\u5f85\u8fd4\u56deC\u6216\u8005D", (String)"DetailParser_8", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), crdr_flag));
            }
            detail.setExplanation(summary);
            JSONObject jsonObject = new JSONObject();
            String json = null;
            if (detailField != null) {
                json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), msg, detailField.getSplit());
            }
            if (StringUtils.isNotEmpty(json)) {
                jsonObject = JSON.parseObject(json);
            }
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("crdr_flag", (Object)crdr_flag);
            jsonObject.put("amt", (Object)amt);
            jsonObject.put("accNo", (Object)acno);
            jsonObject.put("oppAcntNumber", (Object)oppAcntNumber);
            detail.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), tr_acdt, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(host_serial_no);
            detailList.add(detail);
        }
        return detailList;
    }
}

