/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.h2h.services.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bnpp.h2h.util.TH2HPacker;
import kd.ebg.aqap.banks.bnpp.h2h.util.TH2HParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u7b14\u4ed8\u6b3e\u3002", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
        }
        Element simulator = new Element("simulator");
        Element head = TH2HPacker.createHead("QUERY_BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankDetailSeqId());
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = TH2HParser.parseHeader(root);
        if ("BIZ_FAIL".equals(rsp.getResponseCode()) || !"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (lists == null || lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element list = (Element)lists.get(0);
        String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
        Element status = JDomUtils.getChildElement((Element)list, (String)"status");
        String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
        String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if ("BCC_PAY_SUCCESS".equals(txStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else if ("BCC_PAY_ID_NOT_EXIST".equals(txStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPaymentImpl_4", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else if ("BCC_PAY_FAIL".equals(txStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPaymentImpl_4", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else if ("BCC_PAY_SUBMT_SUCCESS".equals(txStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPaymentImpl_5", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eba\u6c11\u5e01\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3002", (String)"QueryPaymentImpl_6", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]);
    }
}

