/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import java.io.File;
import java.util.List;
import kd.bos.orm.util.Assert;
import kd.ebg.aqap.common.constant.BankFileTypeEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractOverseaHandler;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.apache.commons.io.FileUtils;

public abstract class AbstractACKHandler
extends AbstractOverseaHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractACKHandler.class);

    protected abstract List<PaymentInfo> processFile(File var1);

    public abstract boolean isNeedToProcessFile(String var1);

    public void run() {
        try {
            this.preTask();
            this.logger.infoIndex("\u5f00\u59cb\u5904\u7406\u94f6\u884cACK\u6587\u4ef6");
            EBContext context = EBContext.getContext();
            Assert.notNull((Object)context, (String)"EBContext not init");
            String xmlAckFilePath = OverseaFileStorageUtil.getXmlAckFilePath(this.context.getBankVersionID());
            List<File> files = OverseaFileStorageUtil.scanFiles(FileCommonUtils.getFileByPath((String)xmlAckFilePath));
            if (CollectionUtil.isEmpty(files)) {
                this.logger.info("\u626b\u63cfack\u6587\u4ef6\u76ee\u5f55{}\u83b7\u53d6\u5230\u6587\u4ef6\u6570\u91cf\u4e3a0,\u672c\u6b21\u4e0d\u5904\u7406", (Object)xmlAckFilePath);
                return;
            }
            this.logger.info("\u626b\u63cfack\u6587\u4ef6\u76ee\u5f55{}\u83b7\u53d6\u5230\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{xmlAckFilePath, files.size()});
            files.forEach(file -> {
                File newFile = null;
                try {
                    this.saveFileContentToDB(FileUtils.readFileToString((File)file, (String)RequestContextUtils.getCharset()), file.getName(), BankFileTypeEnum.ACK.getName());
                    newFile = this.handleDecryFile((File)file);
                    String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
                    if (Boolean.parseBoolean(needPgp)) {
                        String newName = newFile.getName();
                        newName = "decryption_" + newName;
                        this.saveFileContentToDB(FileUtils.readFileToString((File)newFile, (String)RequestContextUtils.getCharset()), newName, BankFileTypeEnum.ACK.getName());
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u89e3\u5bc6\u6587\u4ef6" + file.getName() + "\u5f02\u5e38", (Throwable)e);
                }
                if (newFile != null && newFile.exists()) {
                    List<PaymentInfo> paymentInfos = this.processFile(newFile);
                    if (CollectionUtil.isNotEmpty(paymentInfos)) {
                        OverseaDBHelper.updatePayInfos(paymentInfos);
                    }
                    this.logger.info("\u94f6\u884c\u7684\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a\uff1a\u6587\u4ef6\u540d=" + file.getName());
                    OverseaFileStorageUtil.cutFile(file, OverseaFileStorageUtil.getXmlAckBakFilePath(context.getBankVersionID()));
                    this.logger.info("\u5907\u4efd\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a\u6210\u529f:" + file.getName());
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u94f6\u884c\u7684ACK\u6587\u4ef6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            this.afterTask();
        }
    }
}

