/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.IBalanceTransfer;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public abstract class AbstractCodelessForeignBalanceImpl
extends AbstractBankXmlImpl
implements IBalanceTransfer,
IBankService<BankBalanceRequest, EBBankBalanceResponse, BankBalanceRequest> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractCodelessForeignBalanceImpl.class);

    boolean async() {
        return false;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBContext context = EBContext.getContext();
        BankAcnt acnt = request.getAcnt();
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        OverseaBalance balance = overseaBalanceRepository.getLastestBalance(acnt.getAccNo(), context.getCustomID(), context.getBankVersionID(), request.getBankCurrency());
        if (balance == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u786e\u8ba4\u94f6\u884c\u662f\u5426\u63a8\u9001\u4e86\u5bf9\u5e94\u7684\u6587\u4ef6\u6570\u636e\u3002", (String)"AbstractCodelessForeignBalanceImpl_0", (String)"ebg-aqap-proxy", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setCurrentBalance(balance.getCurrentBalance());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setLastDayAvlBalance(balance.getLastDayBalance());
        balanceInfo.setBalanceDateTime(balance.getBalanceDate());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }
}

