/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.SFTPMetaDataTemplate;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.framework.handler.AbstractBizHandler;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.AbstractBizScheduleJob;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OverseaBizJob
extends AbstractBizScheduleJob {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaBizJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        BankLogin bankLogin2;
        String bank_login_id;
        String tenantId = RequestContext.get().getTenantId();
        this.logger.info("\u5f00\u59cb\u6267\u884c\u94f6\u884c\u5b9a\u65f6\u8c03\u5ea6");
        BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
        List lists = bankLoginRepository.findOverseaBankByCustomId(tenantId);
        if (CollectionUtil.isEmpty((Collection)lists)) {
            this.logger.info("\u94f6\u884c\u524d\u7f6e\u673a\u914d\u7f6e\u672a\u627e\u5230\uff0c\u8c03\u5ea6\u4e0d\u518d\u6267\u884c");
            return;
        }
        if (map != null && !map.isEmpty() && StringUtils.isNotEmpty((String)(bank_login_id = (String)map.get("bank_login_id"))) && (bankLogin2 = bankLoginRepository.findEnableByBankLoginIdAndCustomId(bank_login_id, tenantId)) != null) {
            lists.clear();
            lists.add(bankLogin2);
        }
        Map<String, List<BankLogin>> collect = lists.stream().collect(Collectors.groupingBy(bankLogin -> bankLogin.getBankVersionId()));
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        HashMap resultMap = new HashMap(10);
        collect.entrySet().stream().forEach(entry -> {
            boolean assignableFrom;
            BankMetaDataCollector bankMetaDataCollectorImpl = bankBundleManager.getBankMetaDataCollectorImpl((String)entry.getKey());
            if (bankMetaDataCollectorImpl != null && (assignableFrom = SFTPMetaDataTemplate.class.isAssignableFrom(bankMetaDataCollectorImpl.getClass().getSuperclass()))) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
        });
        if (resultMap.isEmpty()) {
            this.logger.info("\u63d2\u4ef6\u672a\u7ee7\u627fSFTPMetaDataTemplate\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6587\u4ef6\u4e0b\u8f7d");
            return;
        }
        for (Map.Entry entry2 : resultMap.entrySet()) {
            List bankLogins = (List)entry2.getValue();
            bankLogins.stream().forEach(bankLogin -> {
                EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(tenantId).requestSeqID("").bizName("downloadFile").subBizName("downloadFile").bankVersionID(bankLogin.getBankVersionId()).bankLoginID(bankLogin.getKey().getBankLoginId()).bizSeqID(Sequence.gen18Sequence()).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(String.valueOf(System.currentTimeMillis())).loggerBankNo(Sequence.gen18Sequence()).loggerBatchNo(Sequence.gen18Sequence()).loggerDetailNo(Sequence.gen18Sequence()).schedule(true).build();
                EBContext.setContext((EBContext)context);
                List<AbstractBizHandler> handlers = this.init(context);
                if (CollectionUtil.isEmpty(handlers)) {
                    EBContext.destroy();
                    return;
                }
                EBContext.initParameter();
                MDCUtil.clearBankMDC();
                MDCUtil.initMDC();
                this.logger.infoIndex("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
                super.downLoadFile(bankLogin.getBankVersionId());
                String finalBank_version = bankLogin.getBankVersionId();
                super.fileSaveAs(finalBank_version, handlers);
                handlers.forEach(handler -> {
                    ThreadPool overseaThreadPool = EBThreadPools.getOverseaThreadPool((String)tenantId, (String)finalBank_version);
                    overseaThreadPool.execute((Runnable)handler);
                });
            });
        }
    }

    private List<AbstractBizHandler> init(EBContext context) {
        BankVersion bankVersionInfo = BankBundleManager.getInstance().getBankVersionInfo(context.getBankVersionID());
        boolean needDeleteSftpFile = bankVersionInfo.isNeedDeleteSftpFile();
        HashMap<String, String> runningParams = context.getRunningParams();
        if (CollectionUtils.isEmpty((Map)runningParams)) {
            runningParams = new HashMap<String, String>();
        }
        runningParams.put("is_need_delete_file", String.valueOf(needDeleteSftpFile));
        context.setRunningParams(runningParams);
        List overseaHandlerClasses = bankVersionInfo.getOverseaHandlerClasses();
        ArrayList<AbstractBizHandler> lists = new ArrayList<AbstractBizHandler>(5);
        if (CollectionUtil.isEmpty((Collection)overseaHandlerClasses)) {
            return lists;
        }
        for (Class overseaHandlerClass : overseaHandlerClasses) {
            try {
                AbstractBizHandler abstractBizHandler = (AbstractBizHandler)overseaHandlerClass.newInstance();
                abstractBizHandler.initContext(context);
                lists.add(abstractBizHandler);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error("init error", (Throwable)e);
            }
        }
        return lists;
    }
}

