/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import java.io.InputStream;
import java.io.OutputStream;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.proxy.SDKPgpHelper;
import kd.sdk.ebg.trd.proxy.pgp.SDKPrivateKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKPublicKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKeyRingCollection;

public class PgpHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PgpHelper.class);
    private static PgpHelper instance;

    private PgpHelper() {
    }

    public static synchronized PgpHelper getInstance() {
        if (instance == null) {
            instance = new PgpHelper();
        }
        return instance;
    }

    public SDKPublicKey readPublicKey(InputStream in) {
        try {
            return SDKPgpHelper.getInstance().readPublicKey(in);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public boolean verifySignature(InputStream data, byte[] b, SDKPublicKey key) {
        try {
            return SDKPgpHelper.getInstance().verifySignature(data, b, key);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public byte[] createSignature(InputStream fIn, SDKPrivateKey keyIn, boolean armor) {
        try {
            return SDKPgpHelper.getInstance().createSignature(fIn, keyIn, armor);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public SDKPrivateKey findSecretKey(SDKSecretKey pgpSecKey, char[] pass) {
        try {
            return SDKPgpHelper.getInstance().findSecretKey(pgpSecKey, pass);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    static SDKPrivateKey findSecretKey(SDKSecretKeyRingCollection pgpSec, long keyID, char[] pass) {
        try {
            return SDKPgpHelper.getInstance().findSecretKey(pgpSec, keyID, pass);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public SDKSecretKey readSecretKey(InputStream input) {
        try {
            return SDKPgpHelper.getInstance().readSecretKey(input);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void decryptStream(InputStream in, OutputStream out, InputStream keyIn, char[] password) {
        try {
            SDKPgpHelper.getInstance().decryptStream(in, out, keyIn, password);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void encryptAndSign(OutputStream out, InputStream inputStream, SDKPublicKey encKey, SDKPrivateKey privateKey) {
        try {
            SDKPgpHelper.getInstance().encryptAndSign(out, inputStream, encKey, privateKey);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

