/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.proxy.swift.exception.SwiftException;
import kd.ebg.aqap.proxy.swift.model.field.Field;
import kd.ebg.aqap.proxy.swift.utils.SwiftStringUtils;

public class SwiftParseUtils {
    public static String getTokenFirst(String line, String prefix, String separator) {
        String result = null;
        if (SwiftStringUtils.isNotBlank(line) && SwiftStringUtils.isBlank(result = SwiftStringUtils.substringBefore(line = SwiftParseUtils.removePrefix(line, prefix), separator))) {
            return null;
        }
        return result;
    }

    public static String getTokenFirst(String line, String separator) {
        return SwiftParseUtils.getTokenFirst(line, null, separator);
    }

    public static String removePrefix(String value, String prefix) {
        if (SwiftStringUtils.isNotBlank(value) && SwiftStringUtils.isNotBlank(prefix) && value.startsWith(prefix)) {
            return SwiftStringUtils.substringAfter(value, prefix);
        }
        return value;
    }

    public static String getTokenSecond(String line, String separator) {
        String result = SwiftParseUtils.getTokenFirst(SwiftStringUtils.substringAfter(line, separator), null, separator);
        return result;
    }

    public static String getTokenSecondLast(String line, String separator) {
        String result = SwiftStringUtils.substringAfter(line, separator);
        if (SwiftStringUtils.isBlank(result)) {
            result = null;
        }
        return result;
    }

    public static String getTokenThird(String line, String separator) {
        String result = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenSecondLast(line, separator), separator);
        return result;
    }

    public static String getTokenThirdLast(String line, String separator) {
        String result = null;
        String s1 = SwiftParseUtils.getTokenSecondLast(line, separator);
        if (SwiftStringUtils.isNotBlank(s1) && SwiftStringUtils.isBlank(result = SwiftStringUtils.substringAfter(s1, separator))) {
            result = null;
        }
        return result;
    }

    public static String getTokenForth(String line, String separator) {
        String result = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenThirdLast(line, separator), separator);
        return result;
    }

    public static String getTokenForthLast(String line, String separator) {
        String result = null;
        String s1 = SwiftParseUtils.getTokenThirdLast(line, separator);
        if (SwiftStringUtils.isNotBlank(s1) && SwiftStringUtils.isBlank(result = SwiftStringUtils.substringAfter(s1, separator))) {
            result = null;
        }
        return result;
    }

    public static String getAlphaPrefix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && !SwiftStringUtils.isNumeric(String.valueOf(value.charAt(i))); ++i) {
            }
            if (i > 0) {
                return SwiftStringUtils.substring(value, 0, i);
            }
        }
        return null;
    }

    public static String getNumericPrefix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && (SwiftStringUtils.isNumeric(String.valueOf(value.charAt(i))) || SwiftStringUtils.equals(String.valueOf(value.charAt(i)), ",")); ++i) {
            }
            if (i > 0) {
                return SwiftStringUtils.substring(value, 0, i);
            }
        }
        return null;
    }

    public static String getNumericSuffix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && !SwiftStringUtils.isNumeric(new StringBuffer().append("").append(value.charAt(i)).toString()); ++i) {
            }
            if (i < value.length()) {
                return SwiftStringUtils.substring(value, i);
            }
        }
        return null;
    }

    public static String getAlphaSuffix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && (SwiftStringUtils.isNumeric(new StringBuffer().append("").append(value.charAt(i)).toString()) || SwiftStringUtils.equals(new StringBuffer().append("").append(value.charAt(i)).toString(), ",")); ++i) {
            }
            if (i < value.length()) {
                return SwiftStringUtils.substring(value, i);
            }
        }
        return null;
    }

    public static List getLines(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            BufferedReader br = new BufferedReader(new StringReader(value));
            try {
                String l = br.readLine();
                while (l != null) {
                    result.add(l);
                    l = br.readLine();
                }
            }
            catch (IOException e) {
                throw new SwiftException(e);
            }
        }
        return result;
    }

    public static void setComponentsFromLines(Field f, int startingComponentNumber, int linesToSet, int startingLine, List lines) {
        for (int i = 0; i < linesToSet; ++i) {
            if (lines.size() > startingLine) {
                f.setComponent(startingComponentNumber, (String)lines.get(startingLine));
            }
            ++startingComponentNumber;
            ++startingLine;
        }
    }
}

