/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.payment.samebank;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gyb.dc.payment.QueryPayImpl;
import kd.ebg.aqap.banks.gyb.dc.payment.samebank.TransferSameBankPacker;
import kd.ebg.aqap.banks.gyb.dc.payment.samebank.TransferSameBankParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class TransferSameBankImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse doBiz(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            String rsqt = this.packPay(paymentInfos);
            String s = "/New_B2E/Forward.do?SIGDATA=1&";
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userCif");
            ConnectionFactory factory = this.getConnectionFactory();
            factory.setUri(s);
            factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rsqt);
                try (InputStream is = this.getInputStream(conn);){
                    String rsp = this.recv(is);
                    new TransferSameBankParser().parsePay(paymentInfos, rsp);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String packPay(PaymentInfo[] paymentInfos) {
        String rsqt = new TransferSameBankPacker().packPay(paymentInfos);
        return rsqt;
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public String getBizCode() {
        return "B2eTransferInBank4UTF8";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"TransferSameBankImpl_0", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

